package 
{
	import flash.display.Graphics;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.filters.DropShadowFilter;
	import flash.filters.GlowFilter;
	import flash.text.TextField;
	import flash.utils.getTimer;
	
	
	[SWF(width = "600", height = "400", frameRate = "60", backgroundColor = "#000000", pageTitle = "Line Effect")]	

	public class LineEffect extends Sprite
	{
		private var sp:Sprite = new Sprite();
		private var points:Array = new Array();
		private var prevmouseX:Number = 0;
		private var prevmouseY:Number = 0;
		
		private var fireBtn:MovieClip = new MovieClip();
		private var fireTF:TextField = new TextField();
		
		private var skyBtn:MovieClip = new MovieClip();
		private var skyTF:TextField = new TextField();
		
		private var grassBtn:MovieClip = new MovieClip();
		private var grassTF:TextField = new TextField();
		
		private var sunBtn:MovieClip = new MovieClip();
		private var sunTF:TextField = new TextField();
		
		private var bf:BlurFilter = new BlurFilter(3,3,1);
		private var growFilter:GlowFilter = new GlowFilter(0xff3300, 2, 20, 10, 2, 3, true, false);
		private var growFilter_b:GlowFilter = new GlowFilter(0xfff000, 2, 16, 10, 3, 9, false, false);
		private var dropShadow:DropShadowFilter = new DropShadowFilter(0, 360, 0xC11B17, 1, 70, 70, 5, 3, false, false, false);
		
		private var growFilter_2:GlowFilter = new GlowFilter(0x00ffff, 2, 20, 10, 2, 3, true, false);
		private var growFilter_b_2:GlowFilter = new GlowFilter(0x00ffff, 2, 16, 10, 3, 9, false, false);
		private var dropShadow_2:DropShadowFilter = new DropShadowFilter(0, 360, 0x000fff, 1, 70, 70, 5, 3, false, false, false);
		
		private var growFilter_3:GlowFilter = new GlowFilter(0x4AA02C, 2, 20, 10, 2, 3, true, false);
		private var growFilter_b_3:GlowFilter = new GlowFilter(0x4AA02C, 2, 16, 10, 3, 9, false, false);
		private var dropShadow_3:DropShadowFilter = new DropShadowFilter(0, 360, 0x4AA02C, 1, 70, 70, 5, 3, false, false, false);
		
		private var growFilter_4:GlowFilter = new GlowFilter(0xFDD017, 2, 20, 10, 2, 3, true, false);
		private var growFilter_b_4:GlowFilter = new GlowFilter(0xFDD017, 2, 16, 10, 3, 9, false, false);
		private var dropShadow_4:DropShadowFilter = new DropShadowFilter(0, 360, 0xFDD017, 1, 70, 70, 5, 3, false, false, false);
		
		
		public function LineEffect()
		{
			
			this.addChild(sp);
			this.addEventListener(Event.ENTER_FRAME, onEnter);
			
			drawFireBtn(fireBtn);
			drawSkyBtn(skyBtn);
			drawGrassBtn(grassBtn);
			drawSunBtn(sunBtn);
			
			fireBtn.addEventListener(MouseEvent.CLICK, makeFire);
			skyBtn.addEventListener(MouseEvent.CLICK, makeSky);
			grassBtn.addEventListener(MouseEvent.CLICK,makeGrass);
			sunBtn.addEventListener(MouseEvent.CLICK, makeSun);
			
			sp.filters = [bf, dropShadow];
		}
		
		private function onEnter(e:Event):void
		{
			var line:Graphics = sp.graphics;
			line.clear();
			line.lineStyle(2, 0xffffff);
			line.moveTo(mouseX, mouseY);
			
			
            var dx:Number = this.mouseX - prevmouseX;
			var vx:Number = dx ? dx : Math.random() * randSet(-1, 1);
			var dy:Number = this.mouseY - prevmouseY;
			var vy:Number = dy ? dy : Math.random() * randSet(-1, 1);	
			var pLen:Number = points.push({x:this.mouseX, y:this.mouseY, vx:vx / 20, vy:vy / 20, life:getTimer()});
			
			for (var i:Number = 0; i < pLen; i++) 
			{
				if (!points[i]) 
				{
					continue
				}
				if (getTimer() - points[i].life > 1000) 
				{					
					points.splice(i--, 1)					
				}
				else 
				{
					if (i!=0 && points[i]) 
					{				
						points[i].x += points[i].vx;
						points[i].y += points[i].vy;
						var cx:Number = points[i - 1].x;
						var cy:Number = points[i - 1].y;
						line.curveTo(cx, cy, (points[i].x + cx) * 0.5, (points[i].y + cy) * 0.5 );
					} 
					else 
					{
						line.moveTo(points[i].x, points[i].y);
					}
				}
			}
			
			prevmouseX = this.mouseX;
			prevmouseY = this.mouseY;
        }
        
        private function randSet(p_min:Number,p_max:Number):Number 
		{
			return Math.floor(Math.random() * 2);
		}
		
		private function drawFireBtn(obj:MovieClip):void
		{
			with(obj.graphics)
			{
				beginFill(0x0000ff,0);
			    drawRect(0,0,20,20);
			    endFill();
			}
			fireTF.text = "Fire"
			fireTF.textColor = 0x666666;
			fireTF.mouseEnabled = false;
			fireTF.selectable = false;
			
			this.addChild(obj);
			obj.buttonMode = true;
			obj.addChild(fireTF);
			obj.x = 20;
			obj.y = 380;
		}
		
		private function makeFire(E:MouseEvent):void
		{
			sp.filters = [bf,growFilter,growFilter_b,dropShadow];
			
		}
		
		
		private function drawSkyBtn(obj:MovieClip):void
		{
			with(obj.graphics)
			{
				beginFill(0x0000ff,0);
			    drawRect(0,0,20,20);
			    endFill();
			}
			skyTF.text = "Sky"
			skyTF.textColor = 0x666666;
			skyTF.mouseEnabled = false;
			skyTF.selectable = false;
			
			this.addChild(obj);
			obj.buttonMode = true;
			obj.addChild(skyTF);
			obj.x = 70;
			obj.y = 380;
		}
		
		private function makeSky(e:MouseEvent):void
		{
			sp.filters = [bf,growFilter_2,growFilter_b_2,dropShadow_2];
		}
		
		private function drawGrassBtn(obj:MovieClip):void
		{
			with(obj.graphics)
			{
				beginFill(0x0000ff,0);
			    drawRect(0,0,25,20);
			    endFill();
			}
			grassTF.text = "Grass"
			grassTF.textColor = 0x666666;
			grassTF.mouseEnabled = false;
			grassTF.selectable = false;
			
			this.addChild(obj);
			obj.buttonMode = true;
			obj.addChild(grassTF);
			obj.x = 120;
			obj.y = 380;
		}
		
		private function makeGrass(e:MouseEvent):void
		{
			sp.filters = [bf,growFilter_3,growFilter_b_3,dropShadow_3];
		}
		
		private function drawSunBtn(obj:MovieClip):void
		{
			with(obj.graphics)
			{
				beginFill(0x0000ff,0);
			    drawRect(0,0,20,20);
			    endFill();
			}
			sunTF.text = "Sun"
			sunTF.textColor = 0x666666;
			sunTF.mouseEnabled = false;
			sunTF.selectable = false;
			
			this.addChild(obj);
			obj.buttonMode = true;
			obj.addChild(sunTF);
			obj.x = 170;
			obj.y = 380;
		}
		
		private function makeSun(e:MouseEvent):void
		{
			sp.filters = [bf,growFilter_4,growFilter_b_4,dropShadow_4];
		}
	}
}
