package classes.remoting
{
	import classes.events.CustomEvents;
	
	import flash.events.EventDispatcher;
	
	import mx.controls.Alert;
	import mx.rpc.events.FaultEvent;
	import mx.rpc.events.ResultEvent;
	import mx.rpc.remoting.RemoteObject;
	
	public class ServiceConnector extends EventDispatcher
	{
		private var m_objRemote:RemoteObject;
		private static var m_objServiceConnector:ServiceConnector;
		
		public static function getInstance():ServiceConnector
		{
			if(m_objServiceConnector == null)
				m_objServiceConnector = new ServiceConnector();
				
			return m_objServiceConnector;
		}
		
		public function connect():void
		{
			m_objRemote = new RemoteObject();
			m_objRemote.source = "SaveEvents";
			m_objRemote.destination = "amfphp";
						
			m_objRemote.storeEvents.addEventListener("result", onStoreResult);
			m_objRemote.getEvents.addEventListener("result", onFetchResult);
			m_objRemote.addEventListener("fault", onServiceFault);
			
		}
		
		public function storeEvents(_strEvents:String):void
		{
			if(_strEvents == null || _strEvents == "")
				_strEvents = "<calendar />";
			
			m_objRemote.getOperation("storeEvents").send(_strEvents);
			
		}
		
		public function getEvents():void
		{
			m_objRemote.getOperation("getEvents").send();
		}
		
		private function onStoreResult(evt:ResultEvent):void
		{
			trace("Data  Stored");
		}
		
		private function onFetchResult(evt:ResultEvent):void
		{
			var obj:Object = new Object();
			obj.data = evt.result.toString();
			dispatchEvent(new CustomEvents(CustomEvents.FETCH_DB_DATA, obj));
		}
		
		private function onServiceFault(evt:FaultEvent):void
		{
			trace(evt.message)
			Alert.show("Cannot connect to Webservice, Please check your configuration settings!", "Event Calendar");
		}

	}
}