package classes.views
{
	import classes.CommonUtils;
	
	import mx.containers.Canvas;
	import mx.controls.ComboBox;
	
	public class DTPicker extends Canvas
	{
		private var m_intMaxYearCounter:int = 5;
		
		private var m_intCurrentMonth:int;
		private var m_intCurrentYear:int;
		private var m_objCurrentDate:Date;
		
		public var cmbMonths:ComboBox;
		public var cmbYears:ComboBox;
		
		public function DTPicker()
		{
			m_objCurrentDate = new Date();
		}
		
		public function getDays():void
		{
			var objDate:Date = new Date(m_objCurrentDate.getFullYear(), m_objCurrentDate.month, 1);
			var intTotalDaysInMonth:int = CommonUtils.getDaysCount(m_objCurrentDate.month, m_objCurrentDate.getFullYear());
			
			var arrDays:Array = new Array();
			for(var i:int=0; i<objDate.getDay(); i++)
			{
				arrDays.push("");
			}
			
			for(var i:int=0; i<intTotalDaysInMonth; i++)
			{
				var objDate1:Date = new Date(m_objCurrentDate.getFullYear(), m_objCurrentDate.month, (i+1));
				var strStartDayName:String = CommonUtils.getDayName(objDate1.getDay());
				arrDays.push({data:i+1, label:strStartDayName});
				trace("Day " + (i+1))
				trace("strStartDayName " + strStartDayName)
			}
			
			
			
		}
		
		public function onCreationComplete():void
		{
			
			month = m_objCurrentDate.month;
			year = m_objCurrentDate.getFullYear();
			
			setMonthNames();
			setYears();
			getDays();
		}
		
		public function resetCalendar():void
		{
			
		}
		
		private function setMonthNames():void
		{
			var arrMonths:Array = new Array();
			arrMonths.push({label:"January", data:0});
			arrMonths.push({label:"February", data:1});
			arrMonths.push({label:"March", data:2});
			arrMonths.push({label:"April", data:3});
			arrMonths.push({label:"May", data:4});
			arrMonths.push({label:"June", data:5});
			arrMonths.push({label:"July", data:6});
			arrMonths.push({label:"August", data:7});
			arrMonths.push({label:"September", data:8});
			arrMonths.push({label:"October", data:9});
			arrMonths.push({label:"November", data:10});
			arrMonths.push({label:"Decmber", data:11});
			
			cmbMonths.dataProvider = arrMonths;
		}
		
		private function setYears():void
		{
			var arrYears:Array = new Array();
			var objDate:Date = new Date();
			
			for(var i:int = objDate.getFullYear(); i <= objDate.getFullYear() + m_intMaxYearCounter; i++)
			{
				
				arrYears.push({label:i, data: i});
			}
			
			cmbYears.dataProvider = arrYears;
		}
		
		
		public function set month(_intMonth:int):void
		{
			m_intCurrentMonth = _intMonth;
		}
		
		public function get month():int
		{
			return m_intCurrentMonth;
		}
		
		public function set year(_intYear:int):void
		{
			m_intCurrentYear = _intYear;
		}
		
		public function get year():int
		{
			return m_intCurrentYear;
		}
	}
}