﻿package{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.filesystem.File;
	import flash.filesystem.FileStream;
	import flash.filesystem.FileMode;
	import flash.events.Event;
	import flash.display.BitmapData;
	import flash.utils.ByteArray;
	import fl.events.ColorPickerEvent;
	import flash.geom.ColorTransform;
	import flash.text.TextFormat;
	import flash.text.Font;
	import com.adobe.images.PNGEncoder;
	import com.adobe.images.JPGEncoder;

	public class AirImageEncoder extends Sprite{
		private var saveFileRef:File = File.documentsDirectory;
		private var imageByteArray:ByteArray;
		private var saveFileType:String;
		
		function AirImageEncoder(){
			enc_btn.addEventListener(MouseEvent.MOUSE_DOWN,onEncode);
			colorPickerShirt.addEventListener(ColorPickerEvent.CHANGE,onColorChange);
			colorPickerText.addEventListener(ColorPickerEvent.CHANGE,onColorChange);
			font_cb.addEventListener(Event.CHANGE,onComboChange);
			size_cb.addEventListener(Event.CHANGE,onComboChange);
			populateFonts();
		}
		
		private function onEncode(e:MouseEvent):void{
			switch(jpg_radio.selected){
				case true:
					saveAsJPG();
					break;
				case false:
					saveAsPNG();
					break;
			}
		}
		
		private function populateFonts():void{
			var fontArr:Array = Font.enumerateFonts(true);
			for(var i:uint=0;i<fontArr.length;i++){
				font_cb.addItem({label:fontArr[i].fontName,data:fontArr[i].fontName});
			}
			//find Verdana
			var verdanaIndex:uint;
			for(var f:uint=0;f<fontArr.length;f++){
				if(fontArr[f].fontName == "Verdana"){
					verdanaIndex = f;
					break;
				}
			}
			font_cb.selectedIndex = verdanaIndex;
			
			for(var s:uint=8;s<=30;s++){
				size_cb.addItem({label:s.toString(),data:s});
			}
			size_cb.selectedIndex = 11;
		}
		
		private function getBitmapData():BitmapData{
			var bd:BitmapData = new BitmapData(image_mc.width,image_mc.height);
			bd.draw(image_mc);
			return bd;
		}
		private function saveAsPNG():void{
            imageByteArray = PNGEncoder.encode(getBitmapData());
			browseForSave("PNG");
		}
		private function saveAsJPG():void{
			var jpgEncoder:JPGEncoder = new JPGEncoder(100);
            imageByteArray = jpgEncoder.encode(getBitmapData());
			browseForSave("JPG");
		}
		private function browseForSave(fileType:String):void{
			saveFileType = fileType;
			saveFileRef.browseForSave("Save As " + fileType);
   			saveFileRef.addEventListener(Event.SELECT, onSaveAsSelected);
		}
		private function onSaveAsSelected(e:Event):void{
			saveFileRef = e.target as File;
			var ext:String;
			switch(saveFileType){
				case "JPG":
					ext = ".jpg";
					break;
				case "PNG":
					ext = ".png";
					break;
			}
			if(saveFileRef.extension == null){
				saveFileRef.nativePath += ext;
			}
			var stream:FileStream = new FileStream();
			stream.open(saveFileRef, FileMode.WRITE);
			stream.writeBytes(imageByteArray, 0, imageByteArray.length);
			stream.close();
		}
		
		private function onColorChange(e:ColorPickerEvent):void{
			var colorTransform:ColorTransform;
			
			switch(e.target){
				case colorPickerShirt:
					colorTransform = image_mc.tShirtFill_mc.transform.colorTransform;
					colorTransform.color = e.target.selectedColor;
					image_mc.tShirtFill_mc.transform.colorTransform = colorTransform;
					break;
				case colorPickerText:
					var tf:TextFormat = new TextFormat();
					tf.color = e.target.selectedColor;
					image_mc.text_mc.shirtText_txt.setTextFormat(tf);
					break;
			}
		}
		
		private function onComboChange(e:Event):void{
			var tf:TextFormat = new TextFormat();
			switch(e.target){
				case font_cb:
					tf.font = font_cb.getItemAt(font_cb.selectedIndex).label;
					image_mc.text_mc.shirtText_txt.setTextFormat(tf);
					break;
				case size_cb:
					tf.size = size_cb.getItemAt(size_cb.selectedIndex).label;
					image_mc.text_mc.shirtText_txt.setTextFormat(tf);
					break;
			}
		}
	}
}