﻿/**
* ...
* @author Ankur Arora
* @version 1.0
*/

package 
{
	import flash.display.Loader;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.filters.BitmapFilterQuality;
	import flash.filters.BitmapFilter;
	import flash.filters.GlowFilter;
	import flash.events.*;
	import flash.net.URLRequest;
	import flash.text.*;
	
	public class CustomImageGallery extends MovieClip
	{
		private var m_dataProvider:Array;
		private var m_intImageCount:int = 3;
		private var m_intThumbWidth:int = 100;
		private var m_intThumbHeight:int = 100;
		private var m_intImageWidth:int;
		private var m_intImageHeight:int;
		private var m_mcRightArrow:MovieClip;
		private var m_mcLeftArrow:MovieClip;
		private var m_intCurrentImageCount:int;
		private var m_thumbnailsHolder:MovieClip;
		
		private const m_intSpaceBetweenThumbs:int = 10;
		private const m_intExtraThumbSpace:int = 4;
		private const m_intBigImageBaseWidth:int = 383;
		private const m_intBigImageBaseHeight:int = 337;
		private const m_intBaseColor:uint = 0xFFFFFF;
		private const m_intGlowColor:uint = 0xCCCCCC;
		private const m_intTextCounterheight:int = 25;
		
		public function CustomImageGallery() :void
		{
			
		}
		
		private function generateGallery() :void
		{
			if(dataProvider != null)
			{	
				removeChildren (this);
				var bigImageContainer:MovieClip = new MovieClip ();
				var imgBox:Sprite = new Sprite ();
				var imgLoaderAnim:MovieClip = new mcLoaderAnim ();
				var imgContainer:Loader = new Loader ();
				var txtPageNumber:TextField = new TextField ();
				m_thumbnailsHolder = new MovieClip ();
				m_mcLeftArrow = new mcArrowButton ();
				m_mcRightArrow = new mcArrowButton ();
				
				var filter:BitmapFilter = getBitmapGlowFilter();
				var arrGlowFilter:Array = new Array();
				
				this.addChild (bigImageContainer);
				this.addChild (m_mcLeftArrow);
				this.addChild (m_mcRightArrow);
				this.addChild (m_thumbnailsHolder);
				this.addChild (txtPageNumber);
				
				bigImageContainer.addChild (imgBox);
				bigImageContainer.addChild (imgContainer);
				bigImageContainer.addChild (imgLoaderAnim);
				
				imgLoaderAnim.visible = false;
				
				bigImageContainer.x = thumbWidth + 20;
				
				imgBox.graphics.beginFill (m_intBaseColor, 1);
				imgBox.graphics.drawRect (0, 0, (m_intBigImageBaseWidth), (m_intBigImageBaseHeight));
				imgBox.graphics.endFill ();
				
				arrGlowFilter.push (filter);
				imgBox.filters = arrGlowFilter;
				
				imgLoaderAnim.x 		= (bigImageContainer.width / 2) - (imgLoaderAnim.width / 2);
				imgLoaderAnim.y 		= (bigImageContainer.height / 2) - (imgLoaderAnim.height / 2);
				
				imgContainer.contentLoaderInfo.addEventListener (Event.COMPLETE, onBigImageLoadComplete);
				imgContainer.contentLoaderInfo.addEventListener (IOErrorEvent.IO_ERROR, onBigImageLoadError);
								
				m_mcLeftArrow.y = ((thumbHeight + m_intExtraThumbSpace + m_intSpaceBetweenThumbs) * imgCount) + 5;
				m_mcLeftArrow.x = m_mcLeftArrow.width;
				m_mcLeftArrow.rotation = 180;
				m_mcLeftArrow.buttonMode = true;
				m_mcLeftArrow.addEventListener (MouseEvent.CLICK, onLeftArrowClick);
				
				m_mcRightArrow.y = ((thumbHeight + m_intExtraThumbSpace  + m_intSpaceBetweenThumbs) * imgCount) + 5;
				m_mcRightArrow.x = (thumbWidth  + m_intExtraThumbSpace) - m_mcRightArrow.width;
				m_mcRightArrow.buttonMode = true;
				m_mcRightArrow.addEventListener (MouseEvent.CLICK, onRightArrowClick);
				
				txtPageNumber.x = m_mcLeftArrow.x;
				txtPageNumber.width = m_mcRightArrow.x - m_mcLeftArrow.width;
				txtPageNumber.height = m_intTextCounterheight;
				txtPageNumber.y = m_mcRightArrow.y - m_mcRightArrow.height / 2;
				
				createThumbNails (0);
				m_intCurrentImageCount = 0;
			}
		}
		private function createThumbNails(_intStartCounter:int) :void
		{
			var intThumbnailYPos:int = 0;
			var bigImageContainer:MovieClip = new MovieClip();
			var imgBox:Sprite = new Sprite ();
			var imgLoaderAnim:MovieClip = new mcLoaderAnim ();
			var imgContainer:Loader = new Loader ();
			var filter:BitmapFilter = getBitmapGlowFilter();
			var arrGlowFilter:Array = new Array ();
			arrGlowFilter.push (filter);
			removeChildren (m_thumbnailsHolder);
			for(var i:int = _intStartCounter; i < (_intStartCounter +  imgCount); i++)
			{
				if(typeof(dataProvider[i]) == "object" && i < dataProvider.length)
				{
					var thumbContainer:MovieClip = new MovieClip ();
					var objURLRequest:URLRequest = new URLRequest (dataProvider[i].url);
					imgLoaderAnim = new mcLoaderAnim ();
					imgContainer = new Loader ();
					imgBox = new Sprite ();
					
					
					m_thumbnailsHolder.addChild (thumbContainer);
					thumbContainer.addChild (imgBox);
					thumbContainer.addChild (imgContainer);
					thumbContainer.addChild (imgLoaderAnim);
					
					imgBox.graphics.beginFill (m_intBaseColor, 1);
					imgBox.graphics.drawRect (0, 0, (thumbWidth + m_intExtraThumbSpace), (thumbHeight  + m_intExtraThumbSpace));
					imgBox.graphics.endFill ();
					
					imgBox.filters = arrGlowFilter;

					
					thumbContainer.y 		= intThumbnailYPos;
					imgLoaderAnim.x 		= (thumbContainer.width / 2) - (imgLoaderAnim.width / 2);
					imgLoaderAnim.y 		= (thumbContainer.height / 2) - (imgLoaderAnim.height / 2);
					
					
					intThumbnailYPos 	+= (thumbContainer.height + m_intSpaceBetweenThumbs);
					
					thumbContainer.data = dataProvider[i];
					thumbContainer.buttonMode = true;
					imgContainer.addEventListener (MouseEvent.CLICK, onImageClick);
					imgContainer.contentLoaderInfo.addEventListener (Event.COMPLETE, onImageLoadComplete);
					imgContainer.contentLoaderInfo.addEventListener (IOErrorEvent.IO_ERROR, onImageLoadError);
					
					imgContainer.load (objURLRequest);
				}
			}
			
			resetButtonStates ();
			setPageCount ();
		}
		private function getBitmapGlowFilter ():BitmapFilter 
		{
            var color:Number = m_intGlowColor;
            var alpha:Number = 0.8;
            var blurX:Number = 7;
            var blurY:Number = 7;
            var strength:Number = 2;
            var inner:Boolean = false;
            var knockout:Boolean = false;
            var quality:Number = BitmapFilterQuality.HIGH;

            return new GlowFilter(color,
                                  alpha,
                                  blurX,
                                  blurY,
                                  strength,
                                  quality,
                                  inner,
                                  knockout);
        }
		
		private function removeChildren(_mcContainer:MovieClip) :void
		{
			for (var i:int = 0; i < _mcContainer.numChildren; i++ )
			{
				_mcContainer.removeChildAt (i);
			}
		}
		
		private function loadBigImage(_objData:Object):void 
		{
			var objBigImageContainer:MovieClip = MovieClip (this.getChildAt (0));
			var objBigImageLoader:Loader = Loader (objBigImageContainer.getChildAt (1));
			var objBigImageLoaderAnim:MovieClip = MovieClip (objBigImageContainer.getChildAt (2));
			objBigImageLoaderAnim.visible = true;
			objBigImageLoaderAnim.x = (objBigImageContainer.width / 2) - (objBigImageLoaderAnim.width / 2);
			objBigImageLoaderAnim.y = (objBigImageContainer.height / 2) - (objBigImageLoaderAnim.height / 2);
			objBigImageLoader.load (new URLRequest(_objData.bigURL));
		}
		
		private function resetButtonStates():void 
		{
			m_mcLeftArrow.enabled = true;
			m_mcLeftArrow.alpha = 1;
			
			m_mcRightArrow.enabled = true;
			m_mcRightArrow.alpha = 1;
			
			if (m_intCurrentImageCount == 0)
			{
				m_mcLeftArrow.enabled = false;
				m_mcLeftArrow.alpha = .5;
			}
			
			if (m_intCurrentImageCount >= dataProvider.length - imgCount)
			{
				m_mcRightArrow.enabled = false;
				m_mcRightArrow.alpha = .5;
			}
		}
		
		private function setPageCount() :void
		{
			var txtPageNumber:TextField = TextField (this.getChildAt (4));
			var txtFormat:TextFormat = new TextFormat ();
			var intPageCount:int = m_intCurrentImageCount / imgCount;
			var intTotalPageCount:int = Math.round(dataProvider.length / imgCount);
			txtPageNumber.selectable = false;
			
			intPageCount++;
			txtPageNumber.text =  intPageCount + " / " + intTotalPageCount;
			
			txtFormat.align = "center";
			txtFormat.bold = true;
			txtFormat.font = "Arial";
			txtFormat.size = 12;
				
			txtPageNumber.setTextFormat (txtFormat);
		}

		
		/**
		 * Event Listeners
		 */
		
		private function onImageClick(e:MouseEvent) :void
		{
			var objLoader:Loader = Loader (e.target);
			var objThumbContainer:MovieClip = MovieClip (objLoader.parent);
			
			loadBigImage (objThumbContainer.data);
		} 
		 
		private function onImageLoadComplete(e:Event):void 
		{
			var objLoader:Loader = Loader (e.target.loader);
			var objThumbContainer:MovieClip = MovieClip (objLoader.parent);
			var imgLoaderAnim:* = objThumbContainer.getChildAt (2);
			imgLoaderAnim.visible = false;
			
			objLoader.width = thumbWidth;
			objLoader.height = thumbHeight;
			
			objLoader.x = (objThumbContainer.width / 2) - (objLoader.width / 2);
			objLoader.y = (objThumbContainer.height / 2) - (objLoader.height / 2);
		}
		 
		private function onImageLoadError(e:IOErrorEvent) :void
		{
			
		}
		
		private function onBigImageLoadComplete(e:Event):void 
		{
			var objLoader:Loader = Loader (e.target.loader);
			var objImageContainer:MovieClip = MovieClip (objLoader.parent);
			var objBaseImage:* = objImageContainer.getChildAt (0);
			var imgLoaderAnim:* = objImageContainer.getChildAt (2);
			imgLoaderAnim.visible = false;
			
			objBaseImage.width = objLoader.width + m_intExtraThumbSpace;
			objBaseImage.height = objLoader.height + m_intExtraThumbSpace;
			
			objLoader.x = (objImageContainer.width / 2) - (objLoader.width / 2);
			objLoader.y = (objImageContainer.height / 2) - (objLoader.height / 2);
		}
		 
		private function onBigImageLoadError(e:IOErrorEvent) :void
		{
			
		}
		
		
		private function onLeftArrowClick(e:MouseEvent) :void
		{
			if (e.target.enabled)
			{
				m_intCurrentImageCount -= imgCount;
				createThumbNails (m_intCurrentImageCount);
			}
		}
		
		private function onRightArrowClick (e:MouseEvent):void
		{
			if (e.target.enabled)
			{
				m_intCurrentImageCount += imgCount;
				createThumbNails (m_intCurrentImageCount);
			}
		}
		
		/**
		 * Class Properties
		 */
		public function set dataProvider(_dataProvider:Array) 
		{
			m_dataProvider = _dataProvider;
			generateGallery();
		}
		
		public function get dataProvider():Array
		{
			return m_dataProvider;
		}
		
		[Inspectable(name="Paging Size", type= Number, defaultValue= 3)]
		public function set imgCount(_imgcCount:int) 
		{
			m_intImageCount = _imgcCount;
		}
		
		public function get imgCount():int
		{
			return m_intImageCount;
		}
		
		
		[Inspectable(name="Thumbnail Width", type= Number, defaultValue= 100)]
		public function set thumbWidth(_thumbWidth:int) 
		{
			m_intThumbWidth = _thumbWidth;
		}
		
		public function get thumbWidth():int
		{
			return m_intThumbWidth;
		}
		
		
		[Inspectable(name="Thumbnail Height", type= Number, defaultValue= 100)]
		public function set thumbHeight(_thumbHeight:int) 
		{
			m_intThumbHeight = _thumbHeight;
		}
		
		public function get thumbHeight():int
		{
			return m_intThumbHeight;
		}
	}
}