package
{
	import alternativa.engine3d.events.MouseEvent3D;
	import alternativa.engine3d.primitives.Box;
	import alternativa.engine3d.primitives.Cone;
	import alternativa.engine3d.primitives.GeoSphere;
	import alternativa.engine3d.primitives.Plane;
	import alternativa.types.Point3D;

	import flash.events.MouseEvent;
	import flash.geom.Point;

	import mx.core.Application;

	/**
	 * 	The ApplicationManager holds all program related logic.
	 */
	public class ApplicationManager extends BaseObject
	{
		protected static var instance:ApplicationManager = null;
		protected var box:MeshObject = null;
		protected var boxSelected:Boolean = false;
		protected var cone:MeshObject = null;
		protected var coneSelected:Boolean = false;
		protected var sphere:MeshObject = null;
		protected var sphereSelected:Boolean = false;
		protected var ground:MeshObject = null;

		/**
		 *  returns the singelton instance of the ApplicationManager
		 */
		public static function get Instance():ApplicationManager
		{
			if (instance == null)
				instance = new ApplicationManager();
			return instance;
		}

		public function ApplicationManager()
		{
			super();
		}

		/**
		 *  Initialise the ApplicationManager
		 */
		public function startupApplicationManager():ApplicationManager
		{
			super.startupBaseObject();

			// here we watch for any mouse up event. because we want to stop dragging any object in
			// response to a mouse up event it's best to attach this at the application level
			// rather than with individual Alternativa object
			Application.application.addEventListener(MouseEvent.MOUSE_UP, mouseUp);

			// set the camera to look down at the scene, giving a nice perspective
			Application.application.engineManager.camera.coords = new Point3D(0, 75, -75);
			Application.application.engineManager.cameraController.lookAt(new Point3D());

			// create a 3D object
			box = new MeshObject().startupModelObject(new Box(20, 20, 20));
			// texture it
			box.model.cloneMaterialToAllSurfaces(ResourceManager.redTexture);
			// and add an anonymous function to the mouse down event, which sets a flag that allows us to drag the object around
			box.model.addEventListener(MouseEvent3D.MOUSE_DOWN, function(event:MouseEvent3D):void{boxSelected=true;});

			// repeat for two more 3D objects
			cone = new MeshObject().startupModelObject(new Cone(20, 20));
			cone.model.cloneMaterialToAllSurfaces(ResourceManager.greenTexture);
			cone.model.addEventListener(MouseEvent3D.MOUSE_DOWN, function(event:MouseEvent3D):void{coneSelected=true;});
			cone.model.rotationX = -Math.PI/2.0;
			cone.model.x = 50;

			sphere = new MeshObject().startupModelObject(new GeoSphere(20));
			sphere.model.cloneMaterialToAllSurfaces(ResourceManager.blueTexture);
			sphere.model.addEventListener(MouseEvent3D.MOUSE_DOWN, function(event:MouseEvent3D):void{sphereSelected=true;});
			sphere.model.x = -50;

			// create a Plane to serve as our ground, and rotate it so it is horizontal
			ground = new MeshObject().startupModelObject(new Plane(250, 250, 4, 4));
			ground.model.cloneMaterialToAllSurfaces(ResourceManager.CheckerboardTex);
			ground.model.y = -20;
			ground.model.rotationX = Math.PI/2.0;

			return this;
		}

		public override function enterFrame(dt:Number):void
		{
			// get the point on the ground that lies under the mouse pointer
			var newPoint:Point3D = getCurrentGroundPosition();

			// if anoy object has been clicked on, move that object to the point on the
			// ground
			if (boxSelected)
				box.model.coords = newPoint;
			else if (coneSelected)
				cone.model.coords = newPoint;
			else if (sphereSelected)
				sphere.model.coords = newPoint;
		}

		public function mouseUp(event:MouseEvent):void
		{
			// the mouse button was released, so stop dragging all objects
			boxSelected = false;
			coneSelected = false;
			sphereSelected = false;
		}

		public function getCurrentGroundPosition():Point3D
		{
			// use the get3DCoords to find a point 1 uint into the scene from the camera to the point that the current mouse coordinates
			// translate to. We make this point 1 unit long so we don't incure the expense of normalising the vector later
			var point:Point3D = Application.application.engineManager.view.get3DCoords(new Point(Application.application.mouseX, Application.application.mouseY), 1);
			// the point we found is in the cameras local coordinates, so translate it back into global coordinates
			point = Application.application.engineManager.camera.localToGlobal(point);
			// now use the current cameras position and the mouse pointers global coordinates to create a general dierction vector
			var direction:Point3D = Point3D.difference(point, Application.application.engineManager.camera.coords);

			// find where the plane intersects the ray we calculated abive
			var collision:CollisionResult = MathUtils.testIntersionPlane(new Point3D(0, 1, 0), new Point3D(), Application.application.engineManager.camera.coords, direction);
			// it's possible that the ray is pointing away from or perpendicular to the ground plane, so make sure was actually have
			// found a collision between the ray and the gound plane
			if (collision.result)
			{
				// we have a collision. testIntersionPlane returns the distance along the ray that the intersection with
				// the plane occurs, so multiply the direction vector by this value
				direction.multiply(collision.distance);
				// now add that distance vector to the cameras position, which gets us the collision
				// point on the plane
				return Point3D.sum(Application.application.engineManager.camera.coords, direction);
			}

			// no collision was found, so just return a default Point3D
			return new Point3D();
		}
	}
}