package
{
	import mx.core.Application;
	
	/**
	 *	The BaseObject class allows extending classes to update themselves during the render loop. 
	 */
	public class BaseObject
	{
		public function BaseObject()
		{
			
		}
		
		/**
		 * 	Must be called by all extending classes when being created. Adds this object to the list of BaseObjects maintained
		 * 	by the EngineManager.
		 */
		public function startupBaseObject():void
		{
			Application.application.engineManager.addBaseObject(this);
		}
		
		/**
		 * 	Must be called by all extending classes when being destroyed. Removes this object to the list of BaseObjects maintained
		 * 	by the EngineManager.
		 */
		public function shutdown():void
		{
			Application.application.engineManager.removeBaseObject(this);
		} 
		
		/**
		 * 	This function is called once per frame before the scene is rendered.
		 * 
		 * 	@param dt The time in seconds since the last frame was rendered.
		 */
		public function enterFrame(dt:Number):void
		{
			
		}
	}
}