package
{
	import alternativa.engine3d.core.Camera3D;
	import alternativa.types.Point3D;

	import mx.core.Application;

	/**
	 * 	Takes a screen coordinate and returns a the distance along the ray where
	 *  the collision with the supplied plane occurs, if at all.
	 */
	public final class MathUtils
	{
		public static function testIntersionPlane(planeNormal:Point3D, planePosition:Point3D, rayStart:Point3D, rayDirection:Point3D): CollisionResult
		{
			var dot:Number = Point3D.dot(rayDirection, planeNormal);
			if (dot == 0)
				return new CollisionResult(0, false);

			var collisionDistance:Number = Point3D.dot(planeNormal, Point3D.difference(planePosition, rayStart)) / dot;

			if (collisionDistance <= 0)
				return new CollisionResult(0, false);

			return new CollisionResult(collisionDistance, true);
		}
	}
}