package
{
	import alternativa.engine3d.core.Mesh;
	import alternativa.engine3d.core.Object3D;
	import alternativa.engine3d.materials.FillMaterial;
	import alternativa.engine3d.materials.TextureMaterial;
	import alternativa.types.Texture;
	import alternativa.utils.MeshUtils;

	import flash.display.BitmapData;
	import flash.events.Event;

	/**
	 * 	ResourceManager is where we embed and create the resources needed by our application
	 */
	public class ResourceManager
	{
		[Embed(source='../media/checkerboard.png')]
		public static const Checkerboard:Class;
		public static const CheckerboardTex:TextureMaterial = new TextureMaterial(new Texture(new Checkerboard().bitmapData));


		public static var redTexture:FillMaterial = new FillMaterial(0xFF0000);
		public static var blueTexture:FillMaterial = new FillMaterial(0x0000FF);
		public static var greenTexture:FillMaterial = new FillMaterial(0x00FF00);


		/**
		 *  The ApplicationManager will initilise and the main render loop begin
		 *  when this function returns true.
		 */
		public static function get allResourcesLoaded():Boolean
		{
			return true;
		}

		/**
		 *  This function is called by the EngineManager to load and initialise any resources
		 */
		public static function loadResources():void
		{

		}

		/**
		 * 	This function should be attached as a listener to the ioError
		 *  event when loading resources.
		 */
		protected static function ioError(e:Event):void
		{
			//Application.application.lblLoading.text = "Error Loading";
		}

		/**
		 * 	This function should be attached as a listener to the securityError
		 *  event when loading resources.
		 */
		protected static function securityError(e:Event):void
		{
			//Application.application.lblLoading.text = "Error Loading";
		}

		/**
		  *  This function is used to merge vertices in a loaded model that are
		  *  considered sufficiently close enough as to be the same point. It
		  *  also welds faces to reduce the triangle count.
		  *
		  *  @param object The loaded mesh
		  */
		protected static function weldVerticesAndFaces(object:Object3D):void
		{
			if (object != null)
			{
				if (object is Mesh)
				{
					MeshUtils.autoWeldVertices(Mesh(object), 0.01);
					MeshUtils.autoWeldFaces(Mesh(object), 0.01, 0.001);
				}

				// Launching procedure for object's children
				for (var key:* in object.children)
				{
					weldVerticesAndFaces(key);
				}
			}
		}
	}
}
