package
{
	import alternativa.types.Point3D;
	import alternativa.utils.MathUtils;
	import mx.core.Application;

	/**
	 * 	The ApplicationManager holds all program related logic.
	 */
	public class ApplicationManager extends BaseObject
	{
		protected static const TIME_BETWEEN_PHOTOS:Number = 1;
		protected static const CAMERA_ANGLE:Number = 15;

		/// The singelton instance of this class is referenced here
		protected static var instance:ApplicationManager = null;
		protected var timeToNextPhoto:Number = 0;

		/**
		 *  returns the singelton instance of the ApplicationManager
		 */
		public static function get Instance():ApplicationManager
		{
			if (instance == null)
				instance = new ApplicationManager();
			return instance;
		}

		public function ApplicationManager()
		{
			super();
		}

		/**
		 *  Initialise the ApplicationManager
		 */
		public function startupApplicationManager():ApplicationManager
		{
			super.startupBaseObject();
			
			Application.application.engineManager.camera.rotationY = MathUtils.toRadian(CAMERA_ANGLE);

			return this;
		}

		public override function enterFrame(dt:Number):void
		{
			timeToNextPhoto -= dt;

			if (timeToNextPhoto <= 0)
			{
				timeToNextPhoto = TIME_BETWEEN_PHOTOS;
				new Photo().startupPhoto();
			}

		}

	}
}
