package
{
	import alternativa.engine3d.core.Object3D;

	import mx.core.Application;

	/**
	 * 	A class that extends BaseObject to include a Mesh that is added to the scene
	 */
	public class MeshObject extends BaseObject
	{
		public var model:Object3D = null;

		public function MeshObject()
		{
			super();
		}

		override public function shutdown():void
		{
			super.shutdown();
			Application.application.engineManager.scene.root.removeChild(model);
			model = null;
		}

		public function startupModelObject(object:Object3D):MeshObject
		{
			model = object;
			Application.application.engineManager.scene.root.addChild(model);
			super.startupBaseObject();
			return this;
		}
	}
}