package
{
	import alternativa.engine3d.events.MouseEvent3D;
	import alternativa.engine3d.primitives.Plane;
	import alternativa.utils.MathUtils;

	import flash.net.URLRequest;
	import flash.net.navigateToURL;

	import gs.TweenMax;

	public class Photo extends MeshObject
	{
		// the speed that the photo moves across the screen
		public static var SPEED:Number = 40;
		// photos are placed this far off the side of the screen, and removed when they
		// go past this distance on the other side
		public static var XLIMIT:Number = 200;
		// the y range of the photos
		public static var YVARIANCE:Number = 50;
		// the z range of the photos
		public static var ZVARIANCE:Number = 50;
		// the width of the Plane that displays the photo
		public static var PHOTO_WIDTH:Number = 40;
		// the height of the Plane that displays the photo
		public static var PHOTO_HEIGHT:Number = 60;
		// the scale the the photo will tween to when the mouse is over it
		public static var SCALE_WHEN_MOUSE_OVER:Number = 1.5;
		// the time it takes to tween to the scale specified above
		public static var TWEEN_TIME:Number = 0.5;
		// the index of the image that has been randomly selected for this photo
		protected var image:int = 0;

		public function Photo()
		{
			super();
		}

		public function startupPhoto():Photo
		{
			// create the Plane
			var plane:Plane = new Plane(PHOTO_WIDTH, PHOTO_HEIGHT);
			// place it off to the left of the screen
			plane.x = -XLIMIT;
			// vary the height
			plane.y = MathUtils.random(-YVARIANCE, YVARIANCE);
			// vary the depth
			plane.z = MathUtils.random(-ZVARIANCE, ZVARIANCE);
			// get a random texture
			image = int(MathUtils.random(0, ResourceManager.TextureArray.length));
			// apply the texture
			plane.cloneMaterialToAllSurfaces(ResourceManager.TextureArray[image][0]);
			// listen for a mouse click
			plane.addEventListener(MouseEvent3D.CLICK, mouseClick);
			// listen for the mouse moving over the photo
			plane.addEventListener(MouseEvent3D.MOUSE_OVER, mouseOver);
			// listen for the mouse moving off the photo
			plane.addEventListener(MouseEvent3D.MOUSE_OUT, mouseOut);

			// startup the MeshObject
			super.startupModelObject(plane);
			return this;
		}

		public override function enterFrame(dt:Number):void
		{
			// move the photo across the screen
			this.model.x += SPEED * dt;

			// remove the photo from the system once it is no longer visible
			if (this.model.coords.x >= XLIMIT)
				this.shutdown();
		}

		public override function shutdown():void
		{
			TweenMax.killTweensOf(model);
			super.shutdown();
		}

		public function mouseClick(event:MouseEvent3D):void
		{
			// open up a new window with the image that was just clicked on
			var req:URLRequest = new URLRequest(ResourceManager.TextureArray[image][1]);
            try
            {
                navigateToURL(req);
            }
            catch (e:Error)
            {

            }
		}

		public function mouseOver(event:MouseEvent3D):void
		{
			// scale up, setting yoyo to 0 to indicate that the photo will bounce between normal and enlarged scale
			if (model != null)
				TweenMax.to(model, TWEEN_TIME, {yoyo:0, scaleX:SCALE_WHEN_MOUSE_OVER, scaleY:SCALE_WHEN_MOUSE_OVER, scaleZ:SCALE_WHEN_MOUSE_OVER});
		}

		public function mouseOut(event:MouseEvent3D):void
		{
			// scale back down to original size
			if (model != null)
				TweenMax.to(model, TWEEN_TIME, {overwrite:1, scaleX:1, scaleY:1, scaleZ:1});
		}
	}
}