package
{
	import alternativa.engine3d.core.Mesh;
	import alternativa.engine3d.core.Object3D;
	import alternativa.engine3d.materials.TextureMaterial;
	import alternativa.types.Texture;
	import alternativa.utils.MeshUtils;

	import flash.events.Event;

	import mx.core.Application;

	/**
	 * 	ResourceManager is where we embed and create the resources needed by our application
	 */
	public class ResourceManager
	{
		[Embed(source='../media/image1.png')]
		public static const Image1:Class;
		public static const Image1Tex:TextureMaterial = new TextureMaterial(new Texture(new Image1().bitmapData), 1, true, true);

		[Embed(source='../media/image2.png')]
		public static const Image2:Class;
		public static const Image2Tex:TextureMaterial = new TextureMaterial(new Texture(new Image2().bitmapData), 1, true, true);

		[Embed(source='../media/image3.png')]
		public static const Image3:Class;
		public static const Image3Tex:TextureMaterial = new TextureMaterial(new Texture(new Image3().bitmapData), 1, true, true);

		[Embed(source='../media/image4.png')]
		public static const Image4:Class;
		public static const Image4Tex:TextureMaterial = new TextureMaterial(new Texture(new Image4().bitmapData), 1, true, true);

		/*
			Create an array of the textures and the web address of the full image.
		*/
		public static const TextureArray:Array = [
			[Image1Tex, "http://alternativatut.sourceforge.net/media/Image1.png"],
			[Image2Tex, "http://alternativatut.sourceforge.net/media/Image2.png"],
			[Image3Tex, "http://alternativatut.sourceforge.net/media/Image3.png"],
			[Image4Tex, "http://alternativatut.sourceforge.net/media/Image4.png"]];

		/**
		 *  The ApplicationManager will initilise and the main render loop begin
		 *  when this function returns true.
		 */
		public static function get allResourcesLoaded():Boolean
		{
			return true;
		}

		/**
		 *  This function is called by the EngineManager to load and initialise any resources
		 */
		public static function loadResources():void
		{

		}

		/**
		 * 	This function should be attached as a listener to the ioError
		 *  event when loading resources.
		 */
		protected static function ioError(e:Event):void
		{
			Application.application.lblLoading.text = "Error Loading";
		}

		/**
		 * 	This function should be attached as a listener to the securityError
		 *  event when loading resources.
		 */
		protected static function securityError(e:Event):void
		{
			Application.application.lblLoading.text = "Error Loading";
		}

		/**
		  *  This function is used to merge vertices in a loaded model that are
		  *  considered sufficiently close enough as to be the same point. It
		  *  also welds faces to reduce the triangle count.
		  *
		  *  @param object The loaded mesh
		  */
		protected static function weldVerticesAndFaces(object:Object3D):void
		{
			if (object != null)
			{
				if (object is Mesh)
				{
					MeshUtils.autoWeldVertices(Mesh(object), 0.01);
					MeshUtils.autoWeldFaces(Mesh(object), 0.01, 0.001);
				}

				// Launching procedure for object's children
				for (var key:* in object.children)
				{
					weldVerticesAndFaces(key);
				}
			}
		}
	}
}
