﻿package {
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.text.AntiAliasType;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	import flash.ui.Keyboard;
	import game.BowlingGame;
	
	/**
	 * Document class for 3D Bowling Game
	 * @author Devon O Wolfgang
	 */

	[SWF(width='540', height='450', backgroundColor='#000000', frameRate='60')]
	public class Main extends Sprite {
		
		private var _game:BowlingGame;
		private var _startText:TextField;
		
		public function Main():void {
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);

			initStartText();
			
			stage.addEventListener(KeyboardEvent.KEY_DOWN, startGame);
		}
		
		// Add some intstructions
		private function initStartText():void {
			var fmt:TextFormat = new TextFormat("_sans", 18, 0xFFFFFF);
			fmt.align = TextFormatAlign.CENTER;
			_startText = new TextField();
			_startText.defaultTextFormat = fmt;
			_startText.mouseEnabled = false;
			_startText.selectable = false;
			_startText.multiline = true;
			_startText.antiAliasType = AntiAliasType.ADVANCED;
			_startText.autoSize = TextFieldAutoSize.LEFT;
			_startText.text = "To Play:\n\n1. click the green rectangle to position the ball.\n2. click the red square to roll the ball.\n3. use arrow keys and mouse wheel to move camera.\n\nPRESS SPACE TO BEGIN";
			_startText.x = Math.round(stage.stageWidth * .5 - _startText.width * .5);
			_startText.y = Math.round(stage.stageHeight * .5 - _startText.height * .5);
			addChild(_startText);
		}
		
		// Create the actual game
		private function initGame():void {
			_game = new BowlingGame();
			addChild(_game);
		}
		
		// Remove the instructions and create the game
		private function startGame(event:KeyboardEvent):void {
			if (event.keyCode == Keyboard.SPACE) {
				stage.addEventListener(KeyboardEvent.KEY_DOWN, startGame);
				removeChild(_startText);
				initGame();
			}
		}
	}
}