﻿package game {
	
	import jiglib.geometry.JSphere;
	import jiglib.math.JMatrix3D;
	import jiglib.math.JNumber3D;
	import jiglib.plugin.ISkin3D;

	public class BowlingBall extends JSphere implements IBowlingObject {
		
		private var _resetPosition:JNumber3D;
		
		public function BowlingBall(skin:ISkin3D, r:Number) {
			super(skin, r);
		}
		
		// remove any forces, reset the orientation and move the ball to its starting position
		public function reset():void {
			clearForces();
			currentState.orientation = new JMatrix3D();
			moveTo(_resetPosition);
		}
		
		public function get resetPosition():JNumber3D { return _resetPosition; }
		
		public function set resetPosition(value:JNumber3D):void {
			_resetPosition = value;
		}
	}
}