﻿package game {
	
	import jiglib.geometry.JCapsule;
	import jiglib.math.JMatrix3D;
	import jiglib.math.JNumber3D;
	import jiglib.plugin.ISkin3D;
	
	public class BowlingPin extends JCapsule implements IBowlingObject {
		
		private var _resetPosition:JNumber3D;
		
		public function BowlingPin(skin:ISkin3D, r:Number, l:Number) {
			super(skin, r, l);
		}
		
		// if the pin is less that half in height or it's y value is less than -20, assume it's down
		public function get isDown():Boolean {
			return skin.transform.n22 < .5 || y < -20;
		}
		
		// clear any forces, reset the pin's orientation and move the pin to its starting position
		public function reset():void {
			clearForces();
			currentState.orientation = new JMatrix3D();
			moveTo(_resetPosition);
		}
		
		public function get resetPosition():JNumber3D { return _resetPosition; }
		
		public function set resetPosition(value:JNumber3D):void {
			_resetPosition = value;
		}
	}
}