package
{
	import away3d.materials.TransformBitmapMaterial;
	import away3d.primitives.Plane;
	
	public class BackgroundPlane extends MeshObject
	{
		protected static const ZPOS:Number = 800;
		protected static const WIDTH:Number = 2000;
		protected static const HEIGHT:Number = 400;
		protected static const SPEED:Number = 5;
		protected var material:TransformBitmapMaterial = null;
		
		public function BackgroundPlane()
		{
			super();
		}
		
		public function startupBackgroundPlane(engineManager:EngineManager):BackgroundPlane
		{
			material = ResourceManager.Background1_Tex;
			super.startupMeshObject(
				engineManager,
				new Plane(
					{material:material,
					width:WIDTH,
					height:HEIGHT}));
			this.model.rotationX = 90;
			this.model.z = ZPOS;
			return this;
		}
		
		public override function shutdown():void
		{
			this.material = null;
			super.shutdown();
		} 
		
		public override function enterFrame(dt:Number):void
		{
			material.offsetX -= SPEED * dt;
		}
		
	}
}
