package
{
	import away3d.primitives.Cube;
	
	import mx.core.Application;

	public class ApplicationManager extends BaseObject
	{		
		protected static const TIME_BETWEEN_BUILDINGS:Number = 2;
		protected var timeToNextBuilding:Number = 0;
		
		public function ApplicationManager()
		{
			super();
		}

		public function startupApplicationManager(engineManager:EngineManager):ApplicationManager
		{
			this.startupBaseObject(engineManager);

			return this;
		}
		
		public function startLevel1():void
		{			
			new BackgroundPlane().startupBackgroundPlane(engineManager);
			
			// prepopulate the city
			for (var i:int = 0; i < 5; ++i)
			{
				var building:BackgroundBuilding = new BackgroundBuilding();
				building.startupBackgroundBuilding(engineManager);
				building.enterFrame((i + 1) * 2);
			}
		}
		
		public override function enterFrame(dt:Number):void
		{
			timeToNextBuilding -= dt;
			if (timeToNextBuilding <= 0)
			{
				timeToNextBuilding = TIME_BETWEEN_BUILDINGS;
				new BackgroundBuilding().startupBackgroundBuilding(engineManager);
			}
		}
	}
}