﻿package  {
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Elastic;
	import org.libspark.betweenas3.targets.ITweenTarget;
	import org.libspark.betweenas3.tweens.ITween;

	[SWF(width='540', height='200', backgroundColor='#000000', frameRate='60')]
	public class AddchildTween extends Sprite {
		
		private var _tween:ITween;
		private var _tf:TextField;
		
		public function AddchildTween() {
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(event:Event):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			initText();
			initTween();
			
			stage.addEventListener(MouseEvent.CLICK, toggleTween);
			
		}
		
		private function initText():void {
			var fmt:TextFormat = new TextFormat("_sans", 12, 0xFFFFFF);
			_tf = new TextField();
			_tf.selectable = false;
			_tf.mouseEnabled = false;
			_tf.autoSize = TextFieldAutoSize.LEFT;
			_tf.defaultTextFormat = fmt;
			_tf.text = "Click to start/stop tween.";
			_tf.x = Math.round(stage.stageWidth * .5 - _tf.width * .5);
			_tf.y = Math.round(stage.stageHeight - _tf.height - 10);
			addChild(_tf);
		}
		
		private function initTween():void {
			var targ1:TweenTarget = new TweenTarget();
			targ1.x = 20;
			targ1.y = 25;

			var targ2:TweenTarget = new TweenTarget();
			targ2.x = 20;
			targ2.y = 60;
			
			var targ3:TweenTarget = new TweenTarget();
			targ3.x = 20;
			targ3.y = 95;
			
			/*
			var t1:ITween = BetweenAS3.delay(BetweenAS3.addChild(targ1, this), .5);
			var t2:ITween = BetweenAS3.delay(BetweenAS3.addChild(targ2, this), .5);
			var t3:ITween = BetweenAS3.delay(BetweenAS3.addChild(targ3, this), .5, .5);
			var t4:ITween = BetweenAS3.tween(targ1, { x:500 }, null, 2.0, Elastic.easeOut);
			var t5:ITween = BetweenAS3.tween(targ2, { x:500 }, null, 2.0, Elastic.easeIn);
			var t6:ITween = BetweenAS3.tween(targ3, { x:500 }, null, 2.0, Elastic.easeInOut);
			var t7:ITween = BetweenAS3.parallel(t4, t5, t6);
			var t8:ITween = BetweenAS3.delay(BetweenAS3.removeFromParent(targ1), .5);
			var t9:ITween = BetweenAS3.delay(BetweenAS3.removeFromParent(targ2), .5);
			var t10:ITween = BetweenAS3.delay(BetweenAS3.removeFromParent(targ3), .5);
			*/
			
			_tween = BetweenAS3.serial(BetweenAS3.delay(BetweenAS3.addChild(targ1, this), .5), BetweenAS3.delay(BetweenAS3.addChild(targ2, this), .5), BetweenAS3.delay(BetweenAS3.addChild(targ3, this), .5, .5), BetweenAS3.parallel(BetweenAS3.tween(targ1, { x:500 }, null, 2.0, Elastic.easeOut), BetweenAS3.tween(targ2, { x:500 }, null, 2.0, Elastic.easeIn), BetweenAS3.tween(targ3, { x:500 }, null, 2.0, Elastic.easeInOut)), BetweenAS3.delay(BetweenAS3.removeFromParent(targ1), .5), BetweenAS3.delay(BetweenAS3.removeFromParent(targ2), .5), BetweenAS3.delay(BetweenAS3.removeFromParent(targ3), .5));
			
			//_tween = BetweenAS3.serial(t1, t2, t3, t7, t8, t9, t10);
		}
		
		private function toggleTween(event:MouseEvent):void {
			if (_tween.isPlaying) {
				_tween.stop();
			} else {
				if (_tween.position == _tween.duration) {
					_tween.gotoAndPlay(0);
				} else {
					_tween.play();
				}
			}
		}
	}
}