﻿package  {
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.GlowFilter;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Expo;
	import org.libspark.betweenas3.tweens.ITween;

	[SWF(width='540', height='200', backgroundColor='#000000', frameRate='60')]
	public class FilterTween extends Sprite {
		
		private var _tween:ITween;
		private var _tf:TextField;
		
		public function FilterTween() {
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(event:Event):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			initText();
			initTween();
			
			stage.addEventListener(MouseEvent.CLICK, toggleTween);
			
		}
		
		private function initText():void {
			var fmt:TextFormat = new TextFormat("_sans", 12, 0xFFFFFF);
			_tf = new TextField();
			_tf.selectable = false;
			_tf.mouseEnabled = false;
			_tf.autoSize = TextFieldAutoSize.LEFT;
			_tf.defaultTextFormat = fmt;
			_tf.text = "Click to start/stop tween.";
			_tf.x = Math.round(stage.stageWidth * .5 - _tf.width * .5);
			_tf.y = Math.round(stage.stageHeight - _tf.height - 10);
			addChild(_tf);
		}
		
		private function initTween():void {
			var targ:TweenTarget = new TweenTarget();
			targ.x = 235;
			targ.y = 40;
			targ.scaleX = 3;
			targ.scaleY = 3;
			addChild(targ);
			targ.filters = [new GlowFilter(0xFFFF00, 1, 0, 0, 2, 3)];
			var t1:ITween = BetweenAS3.tween(targ, { _glowFilter: { blurX:32, blurY:32 } }, { _glowFilter: { blurX:0, blurY:0 }},  1.0, Expo.easeOut);
			_tween = BetweenAS3.serial(t1, BetweenAS3.reverse(t1));
			_tween.stopOnComplete = false;
		}
		
		private function toggleTween(event:MouseEvent):void {
			if (_tween.isPlaying) {
				_tween.stop();
			} else {
				if (_tween.position == _tween.duration) {
					_tween.gotoAndPlay(0);
				} else {
					_tween.play();
				}
			}
		}
	}
}