﻿package  {
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Expo;
	import org.libspark.betweenas3.events.BetweenEvent;
	import org.libspark.betweenas3.tweens.ITween;

	[SWF(width='540', height='200', backgroundColor='#000000', frameRate='60')]
	public class FunctionTween extends Sprite {
		
		private var _tween:ITween;
		private var _tf:TextField;
		
		public function FunctionTween() {
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(event:Event):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			initText();
			initTween();
			
			stage.addEventListener(MouseEvent.CLICK, toggleTween);
			
		}
		
		private function initText():void {
			var fmt:TextFormat = new TextFormat("_sans", 12, 0xFFFFFF);
			_tf = new TextField();
			_tf.selectable = false;
			_tf.mouseEnabled = false;
			_tf.autoSize = TextFieldAutoSize.LEFT;
			_tf.defaultTextFormat = fmt;
			_tf.text = "Click to start/stop tween.";
			_tf.x = Math.round(stage.stageWidth * .5 - _tf.width * .5);
			_tf.y = Math.round(stage.stageHeight - _tf.height - 10);
			addChild(_tf);
		}
		
		private function initTween():void {
			var targ:TweenTarget = new TweenTarget();
			targ.x = 20;
			targ.y = 60;
			addChild(targ);
			_tween = BetweenAS3.serial(BetweenAS3.tween(targ, { x:500 }, null, 2.0, Expo.easeOut), BetweenAS3.func(tweenFunction, ["The tween is over."]));
		}
		
		private function tweenFunction(words:String):void {
			_tf.text = words;
		}
		
		private function toggleTween(event:MouseEvent):void {
			if (_tween.isPlaying) {
				_tween.stop();
			} else {
				if (_tween.position == _tween.duration) {
					_tween.gotoAndPlay(0);
				} else {
					_tween.play();
				}
			}
		}
	}
}