﻿package  {
	
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.filters.ColorMatrixFilter;
	import flash.filters.ConvolutionFilter;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Quad;
	import org.libspark.betweenas3.events.BetweenEvent;
	import org.libspark.betweenas3.tweens.ITween;
	
	[SWF(width='540', height='450', backgroundColor='#000000', frameRate='60')]
	public class MatrixTween extends Sprite {
		
		[Embed(source = "../assets/prague.jpg")]
		private var JPG:Class;
		
		private var _image:Sprite;
		private var _tween:ITween;
		private var _tf:TextField;
		
		private var _matrixArray:Array = [ 0, 0, 0, 0, 1, 0, 0, 0, 0];
		private var _convFilter:ConvolutionFilter = new ConvolutionFilter(3, 3, _matrixArray);
		
		// IDENTITY ARRAY:	(0,0,0,0,1,0,0,0,0)
		// EMBOSS ARRAY:	(-2,-1,0,-1,1,1,0,1,2);
		
		public function MatrixTween() {
			_image = new Sprite();
			_image.addChild(new JPG());
			addChild(_image);
			
			initText();
			initTween();
			
			stage.addEventListener(MouseEvent.CLICK, toggleTween);
		}
		
		private function initText():void {
			var fmt:TextFormat = new TextFormat("_sans", 12, 0xFFFFFF);
			_tf = new TextField();
			_tf.selectable = false;
			_tf.mouseEnabled = false;
			_tf.autoSize = TextFieldAutoSize.LEFT;
			_tf.defaultTextFormat = fmt;
			_tf.text = "Click to start/stop tween.";
			_tf.x = Math.round(stage.stageWidth * .5 - _tf.width * .5);
			_tf.y = Math.round(stage.stageHeight - _tf.height - 10);
			addChild(_tf);
		}
		
		private function initTween():void {
			var t1:ITween = BetweenAS3.tween(_matrixArray, { 0: -2, 1: -1, 3: -1, 4:1, 5:1, 7:1, 8:2 }, { 0:0, 1:0, 3:0, 4:1, 5:0, 7:0, 8:0 }, 2.0, Quad.easeInOut);
			_tween = BetweenAS3.serial(t1, BetweenAS3.reverse(t1));
			_tween.addEventListener(BetweenEvent.UPDATE, applyFilter);
		}
		
		private function applyFilter(event:BetweenEvent):void {
			_convFilter.matrix = _matrixArray;
			_image.filters = [_convFilter];
		}
		
		private function toggleTween(event:MouseEvent):void {
			if (_tween.isPlaying) {
				_tween.stop();
			} else {
				if (_tween.position == _tween.duration) {
					_tween.gotoAndPlay(0);
				} else {
					_tween.play();
				}
			}
		}
	}
}