﻿package  {
	
	import com.durej.pv3d.Starfield;
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Quadratic;
	import org.libspark.betweenas3.tweens.ITween;
	
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	
	[SWF(width='540', height='200', backgroundColor='#000000', frameRate='60')]
	public class PV3dtween extends Sprite {
		
		private var _cam:Camera3D;
		private var _engine:BasicRenderEngine;
		private var _scene:Scene3D;
		private var _view:Viewport3D;
		private var _sphere:Sphere;
		
		private var _tf:TextField;
		private var _tween:ITween;
		
		public function PV3dtween() {
			init3d();
			initTween();
			initText();
			
			addEventListener(Event.ENTER_FRAME, render);
			stage.addEventListener(MouseEvent.CLICK, toggleTween);
		}
		
		private function initText():void {
			var fmt:TextFormat = new TextFormat("_sans", 12, 0xFFFFFF);
			_tf = new TextField();
			_tf.selectable = false;
			_tf.mouseEnabled = false;
			_tf.autoSize = TextFieldAutoSize.LEFT;
			_tf.defaultTextFormat = fmt;
			_tf.text = "Click to start/stop tween.";
			_tf.x = Math.round(stage.stageWidth * .5 - _tf.width * .5);
			_tf.y = Math.round(stage.stageHeight - _tf.height - 10);
			addChild(_tf);
		}
		
		private function init3d():void {
			var wfmat:WireframeMaterial = new WireframeMaterial();
			_sphere = new Sphere(wfmat, 150);
			
			var sf:Starfield = new Starfield();
			
			_cam = new Camera3D();
			_cam.target = _sphere;
			
			_scene = new Scene3D();
			_scene.addChild(_sphere);
			_scene.addChild(sf);
			
			_view = new Viewport3D(stage.stageWidth, stage.stageHeight);
			addChild(_view);
			
			_engine = new BasicRenderEngine();
		}
		
		private function initTween():void {
			var t1:ITween = BetweenAS3.tween(_cam, { x:1000, y:1000 }, null, 2.0, Quadratic.easeInOut);
			var t2:ITween = BetweenAS3.tween(_cam, { z:1000, y:-1000 }, null, 2.0, Quadratic.easeInOut );
			var t3:ITween = BetweenAS3.tween(_cam, { x: -1000, y:1000 }, null, 2.0, Quadratic.easeInOut);
			var t4:ITween = BetweenAS3.tween(_cam, { z: -1000, y:-1000 }, null, 2.0, Quadratic.easeInOut);
			var t5:ITween = BetweenAS3.tween(_cam, { x:0, y:0 }, null, 2.0, Quadratic.easeInOut);
			
			_tween = BetweenAS3.repeat(BetweenAS3.serial(t1, t2, t3, t4, t5), 1);
			_tween.stopOnComplete = false;
		}
		
		private function toggleTween(event:MouseEvent):void {
			if (_tween.isPlaying) {
				_tween.stop();
			} else {
				if (_tween.position == _tween.duration) {
					_tween.gotoAndPlay(0);
				} else {
					_tween.play();
				}
			}
		}
		
		private function render(event:Event):void {
			_sphere.rotationY ++;
			_engine.renderScene(_scene, _cam, _view);
		}
	}
}