﻿package  {
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Quad;
	import org.libspark.betweenas3.events.BetweenEvent;
	import org.libspark.betweenas3.tweens.ITween;

	[SWF(width='540', height='200', backgroundColor='#000000', frameRate='60')]
	public class PointTween extends Sprite {
		
		private var _tween:ITween;
		private var _tf:TextField;
		private var _cover:BitmapData;
		private var _point:Point = new Point();
		
		public function PointTween() {
			addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(event:Event):void {
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			initDisplay();
			initText();
			
			stage.addEventListener(MouseEvent.CLICK, doTween);
			
		}
		
		private function initText():void {
			var fmt:TextFormat = new TextFormat("_sans", 12, 0xFFFFFF);
			_tf = new TextField();
			_tf.selectable = false;
			_tf.mouseEnabled = false;
			_tf.autoSize = TextFieldAutoSize.LEFT;
			_tf.defaultTextFormat = fmt;
			_tf.text = "Click to draw a line to the mouse.";
			_tf.x = Math.round(stage.stageWidth * .5 - _tf.width * .5);
			_tf.y = Math.round(stage.stageHeight - _tf.height - 10);
			addChild(_tf);
		}
		
		private function initDisplay():void {
			_cover = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFF000000);
			var display:Bitmap = new Bitmap(_cover);
			addChild(display);
		}
		
		private function doTween(event:MouseEvent):void {
			if (_tween && _tween.isPlaying) _tween.stop();
			_tween = BetweenAS3.tween(_point, { x:event.stageX, y:event.stageY }, null, 1.0, Quad.easeOut );
			_tween.addEventListener(BetweenEvent.UPDATE, drawLine);
			_tween.play();
		}
		
		private function drawLine(event:BetweenEvent):void {
			_cover.lock();
			_cover.setPixel(_point.x, _point.y, 0xFFFFFF);
			_cover.unlock();
		}
	}
}