package
{
	import mx.core.Application;

	public class ApplicationManager extends BaseObject
	{		
		protected static const TIME_BETWEEN_BUILDINGS:Number = 2;
		protected static const TIME_BETWEEN_ENEMIES:Number = 1;
		protected static const TIME_TO_LEVEL_END:Number = 1;
		protected var timeToEndGame:Number = TIME_TO_LEVEL_END;
		protected var timeToNextBuilding:Number = 0;
		protected var timeToNextEnemy:Number = TIME_BETWEEN_ENEMIES;		
		protected var levelHasEnded:Boolean = false;
		protected var myPlayerWeapon:int = 1;
		protected var myPlayerWeaponLevel:int = 1;
		protected var myWeaponManager:WeaponManager = null;
		public var myScore:int = 0;
		
		public function get MyWeaponManager():WeaponManager
		{
			return myWeaponManager;	
		}
		
		public function get MyScore():int
		{
			return myScore;	
		}
		
		public function get MyPlayerWeapon():int
		{
			return myPlayerWeapon;	
		}
		
		public function get MyPlayerWeaponLevel():int
		{
			return myPlayerWeaponLevel;	
		}
		
		public function set score(value:int):void
		{
			myScore = value;
			Application.application.lblScore.text = myScore;
		}
		
		public function ApplicationManager()
		{
			super();
		}

		public function startupApplicationManager(engineManager:EngineManager):ApplicationManager
		{
			this.startupBaseObject(engineManager);
			this.engineManager.addCollidingPair(CollisionIdentifiers.ENEMY, CollisionIdentifiers.PLAYER);
			this.engineManager.addCollidingPair(CollisionIdentifiers.ENEMY, CollisionIdentifiers.PLAYERWEAPON);
			this.myWeaponManager = new WeaponManager().startupWeaponManager(this.engineManager);
			
			return this;
		}
		
		public function startLevel1():void
		{			
			timeToNextBuilding = 0;
			score = 0;
			
			new BackgroundPlane().startupBackgroundPlane(engineManager);
			new Player().startupPlayer(engineManager);
			
			// prepopulate the city
			for (var i:int = 0; i < 5; ++i)
			{
				var building:BackgroundBuilding = new BackgroundBuilding();
				building.startupBackgroundBuilding(engineManager);
				building.enterFrame((i + 1) * 2);
			}
		}
		
		public function levelEnded():void
		{
			levelHasEnded = true;
		}
		
		public override function shutdown():void
		{			
			super.shutdown();
		}
		
		public override function enterFrame(dt:Number):void
		{
			timeToNextBuilding -= dt;
			if (timeToNextBuilding <= 0)
			{
				timeToNextBuilding = TIME_BETWEEN_BUILDINGS;
				new BackgroundBuilding().startupBackgroundBuilding(engineManager);
			}
			
			timeToNextEnemy -= dt;
			if (timeToNextEnemy <= 0)
			{
				timeToNextEnemy = TIME_BETWEEN_ENEMIES;
				new Enemy().startupBasicEnemy(engineManager);
			}
			
			if (levelHasEnded)
			{
				timeToEndGame -= dt;
				if (timeToEndGame <= 0)
				{
					engineManager.nextStateChange = "MainMenu";
				}
			}
		}
	}
}