package
{
	import away3d.core.math.Number3D;
	
	public class BasicWeapon extends Weapon
	{
		protected static const WEAPON_SIZE:Number = 2;
		protected var speed:Number = 0;
		protected var direction:Number3D = null;
		
		public function BasicWeapon()
		{
			super();
		}
		
		protected function startupBasicWeapon(engineManager:EngineManager, position:Number3D, damage:int, xDir:Number, yDir:Number, speed:Number):BasicWeapon
		{
			this.startupWeapon(engineManager, ResourceManager.Bullet_Tex, position, WEAPON_SIZE, WEAPON_SIZE, damage);
			this.direction = new Number3D(xDir, yDir, 0);
			this.direction.normalize();
			this.speed = speed;
			return this;			
		}
		
		public function startupBasicPlayerWeapon(engineManager:EngineManager, position:Number3D, damage:int, xDir:Number, yDir:Number, speed:Number):BasicWeapon
		{
			startupBasicWeapon(engineManager, position, damage, xDir, yDir, speed);
			this.collisionName = CollisionIdentifiers.PLAYERWEAPON;
			return this;
		}
		
		public function startupBasicEnemyWeapon(engineManager:EngineManager, position:Number3D, damage:int, xDir:Number, yDir:Number, speed:Number):BasicWeapon
		{
			startupBasicWeapon(engineManager, position, damage, xDir, yDir, speed);
			this.collisionName = CollisionIdentifiers.ENEMYWEAPON;
			return this;
		}
		
		public override function enterFrame(dt:Number):void
		{
			this.model.x += speed * dt;
			
			super.enterFrame(dt);
		}

	}
}