package
{
	import org.flintparticles.threeD.emitters.Emitter3D;
	import org.flintparticles.common.events.EmitterEvent;
	
	public class EmitterContainer extends BaseObject
	{
		protected var emitter:Emitter3D = null;
		
		public function EmitterContainer()
		{
			super();
		}
		
		public function startupEmitterContainer(engineManager:EngineManager, emitter:Emitter3D):EmitterContainer
		{
			super.startupBaseObject(engineManager);
			this.emitter = emitter;
			this.engineManager.renderer.addEmitter(emitter);
			this.emitter.addEventListener( EmitterEvent.EMITTER_EMPTY, removeEmitter, false, 0, true );
			this.emitter.start();
			return this;
		}
		
		public function removeEmitter( ev:EmitterEvent ):void
		{						
			this.shutdown();			
		}
		
		public override function shutdown():void
		{
			this.emitter.removeEventListener( EmitterEvent.EMITTER_EMPTY, removeEmitter );			
			this.engineManager.renderer.removeEmitter(this.emitter);
			this.emitter = null;
			super.shutdown();
		}
		
	}
}