package
{
	import away3d.materials.BitmapMaterial;
	import away3d.primitives.Plane;
	
	public class Enemy extends DamageableObject
	{
		protected static const ENEMY_X_LIMIT:Number = 70;
		protected static const ENEMY_Y_LIMIT:Number = 60;
		protected static const ENEMY_X_START:Number = 65;
		protected static const ENEMY_Y_START:Number = 55;
		protected static const ENEMY_WIDTH:Number = 16;
		protected static const ENEMY_HEIGHT:Number = 5;
		protected static const BASIC_ENEMY_SPEED:Number = 50;
		protected static const BASIC_ENEMY_SHIELDS:Number = 1;
		protected static const BASIC_ENEMY_SCORE:Number = 10;
		protected var logic:Function = null;
		protected var score:int = 0;
		
		public function Enemy()
		{
			super();
		}
		
		public override function shutdown():void
		{
			super.shutdown();
			this.logic = null;
		}
		
		protected function startupEnemy(engineManager:EngineManager, material:BitmapMaterial):Enemy
		{
			var plane:Plane = new Plane(
				{material:material,
				width:ENEMY_WIDTH,
				height:ENEMY_HEIGHT,
				yUp:false});
			super.startupMeshObject(engineManager, plane);
			
			this.collisionName = CollisionIdentifiers.ENEMY;
			
			return this;
		}
		
		public function startupBasicEnemy(engineManager:EngineManager):Enemy
		{
			this.startupEnemy(engineManager, ResourceManager.Enemy_Tex);
			this.logic = basicEnemyLogic;
			this.model.x = ENEMY_X_LIMIT;
			this.model.y = MathUtils.randRange(-ENEMY_Y_START, ENEMY_Y_START);
			this.shields = BASIC_ENEMY_SHIELDS;
			this.score = BASIC_ENEMY_SCORE; 
			return this;
		}
		
		public override function enterFrame(dt:Number):void
		{
			if (logic != null)
				logic(dt);
				
			if (this.model.x > ENEMY_X_LIMIT ||
				this.model.x < -ENEMY_X_LIMIT ||
				this.model.y > ENEMY_Y_LIMIT ||
				this.model.y < -ENEMY_Y_LIMIT)
				this.shutdown();
		}
		
		protected function basicEnemyLogic(dt:Number):void
		{
			this.model.x -= BASIC_ENEMY_SPEED * dt;
		}
		
		protected override function die():void
		{
			engineManager.MyApplicationManager.myScore += this.score;
			super.die();
		}
		
		public override function collision(other:MeshObject):void
		{
			if (other.collisionName == CollisionIdentifiers.PLAYER)
			{
				this.die();
				(other as Player).damage(this.shields);
			}
		}
	}
}