package
{
	import away3d.core.base.Object3D;

	internal class MeshObject extends BaseObject
	{
		public var model:Object3D = null;
		public var collisionName:String = CollisionIdentifiers.NONE;
		
		public function MeshObject()
		{
			super();
		}
		
		public function startupMeshObject(engineManager:EngineManager, model:Object3D):MeshObject
		{
			super.startupBaseObject(engineManager);
			this.model = model;
			this.engineManager.view.scene.addChild(model);
			return this;
		}
		
		public override function shutdown():void
		{
			if (model != null)
				engineManager.view.scene.removeChild(model);			
			model = null;
			super.shutdown();
		}
		
		public function intersects(other:MeshObject):Boolean
		{
				// Use up to 6 separating planes
			if ( this.model.maxX + this.model.x < other.model.minX + other.model.x )
				return false;
			if ( this.model.maxY + this.model.y < other.model.minY + other.model.y )
 				return false;
			if ( this.model.maxZ + this.model.z < other.model.minZ + other.model.z )
				return false;

   			if ( this.model.minX + this.model.x > other.model.maxX + other.model.x )
   				return false;
   			if ( this.model.minY + this.model.y > other.model.maxY + other.model.y )
   				return false;
   			if ( this.model.minZ + this.model.z > other.model.maxZ + other.model.z)
				return false;

			// otherwise, must be intersecting
			return true;
		}
		
		public function collision(other:MeshObject):void
		{
		
		}
	}
}