package
{
	import away3d.core.math.Number3D;
	import away3d.materials.BitmapMaterial;
	import away3d.primitives.Plane;
	
	public class Weapon extends MeshObject
	{
		protected static const WEAPON_X_LIMIT:Number = 70;
		protected static const WEAPON_Y_LIMIT:Number = 60;
		protected var damage:int = 0;
		
		public function Weapon()
		{
			super();
		}
		
		public override function shutdown():void
		{
			super.shutdown();
		}
		
		public function startupWeapon(engineManager:EngineManager, material:BitmapMaterial, position:Number3D, sizeX:Number, sizeY:Number, damage:int):Weapon
		{
			var plane:Plane = new Plane(
				{material:material,
				width:sizeX,
				height:sizeY,
				yUp:false});
			super.startupMeshObject(engineManager, plane);
			this.model.position = position;
			this.damage = damage;
			
			return this;
		}
		
		public override function enterFrame(dt:Number):void
		{
			if (this.model.x > WEAPON_X_LIMIT ||
				this.model.x < -WEAPON_X_LIMIT ||
				this.model.y > WEAPON_Y_LIMIT ||
				this.model.y < -WEAPON_Y_LIMIT)
				this.shutdown();
		}
		
		public override function collision(other:MeshObject):void
		{
			if (other.collisionName == CollisionIdentifiers.ENEMY ||
				other.collisionName == CollisionIdentifiers.PLAYER)
				(other as DamageableObject).damage(this.damage);
			this.shutdown();
		}
	}
}