package
{
	import away3d.materials.BitmapMaterial;
	import away3d.primitives.Cube;
	import away3d.primitives.data.CubeMaterialsData;
	
	public class BackgroundBuilding extends MeshObject
	{
		protected static const SPEED:Number = 50;
		protected static const XLIMIT:Number = 350;
		protected static const YPOSITION:Number = -120;
		protected static const MAXHEIGHT:Number = 300;
		protected static const MINHEIGHT:Number = 100;
		protected static const MINWIDTH:Number = 50;
		protected static const MAXWIDTH:Number = 75;
		protected static const MINDEPTH:Number = 200;
		protected static const MAXDEPTH:Number = 750;
		
		public function BackgroundBuilding()
		{
			super();
		}
		
		public function startupBackgroundBuilding(engineManager:EngineManager):void
		{
			var material:BitmapMaterial = null;
			switch (MathUtils.randomInteger(0, 3))
			{
				case 0:
					material = ResourceManager.Building1_Tex;
					break;
				case 1:
					material = ResourceManager.Building2_Tex;
					break;
				case 2:
					material = ResourceManager.Building3_Tex;
					break;
			}
			
			// the cube needs to have 6 textures defined
			var buildingMaterial:CubeMaterialsData = 
				new CubeMaterialsData(
					{left:material,
					right:material,
					front:material,
					back:material,
					top:ResourceManager.Roof1_Tex});
			
			super.startupMeshObject(
				engineManager,
				new Cube(
					{faces:buildingMaterial,
					width:MathUtils.randRange(MINWIDTH, MAXWIDTH),
					depth:MathUtils.randRange(MINWIDTH, MAXWIDTH),
					height:MathUtils.randRange(MINHEIGHT, MAXHEIGHT)}));
					
			this.model.z = MathUtils.randRange(MINDEPTH, MAXDEPTH);
			this.model.x = XLIMIT;
			this.model.y = YPOSITION; 		
		}
		
		public override function enterFrame(dt:Number):void
		{
			this.model.x -= SPEED * dt;
			if (this.model.x <= -XLIMIT)
				this.shutdown();
		}
	}
}