package
{
	import away3d.cameras.Camera3D;
	import away3d.containers.View3D;
	import away3d.core.math.Number3D;
	import away3d.core.render.Renderer;
	import away3d.events.*;
	
	import flash.display.*;
	import flash.events.*;
	import flash.utils.*;
	
	import mx.collections.*;
	import mx.core.*;
	

	public class EngineManager extends UIComponent
	{
		public static const version:String = "1.0.0";
		protected static const MEASURED_MIN_WIDTH:int = 25;
		protected static const MEASURED_MIN_HEIGHT:int = 25;
		protected static const MEASURED_WIDTH:int = 100;
		protected static const MEASURED_HEIGHT:int = 100;
		
		// Away3D view
		internal var view:View3D = null;
		// Away3D camera
		internal var cam:Camera3D = null;
		// Away3D Flint renderer
		internal var renderer:Away3DRenderer = null;
		// a collection of the BaseObjects
		protected var baseObjects:ArrayCollection = new ArrayCollection();
		// a collection where new BaseObjects are placed, to avoid adding items
		// to baseObjects while in the baseObjects collection while it is in a loop
		protected var newBaseObjects:ArrayCollection = new ArrayCollection();
		// a collection where removed BaseObjects are placed, to avoid removing items
		// to baseObjects while in the baseObjects collection while it is in a loop
		protected var removedBaseObjects:ArrayCollection = new ArrayCollection();
		// the last frame time
		protected var lastFrame:Date;
		// the application manager
		protected var applicationManager:ApplicationManager = null;
		// true if we need to shutdown the engine during the next frame and drop back to the main menu
		protected var myNextStateChange:String = "";
		// collision mappings
		protected var collisionMap:Dictionary = new Dictionary();
		
		internal function get MyApplicationManager():ApplicationManager
		{
			return applicationManager;
		}

		public function EngineManager()
		{
			super();			
			addEventListener(Event.REMOVED_FROM_STAGE, this.shutdown);
			addEventListener(Event.ADDED_TO_STAGE, this.initializeEngine);			
		}

		override protected function measure():void
		{
			super.measure();

			// set a bunch of predefined sizes
			this.measuredMinWidth = MEASURED_MIN_WIDTH;
			this.measuredMinHeight = MEASURED_MIN_HEIGHT;
			this.measuredHeight = MEASURED_HEIGHT;
			this.measuredWidth = MEASURED_WIDTH;
		}

		override protected function updateDisplayList(unscaledWidth:Number, unscaledHeight:Number):void
		{
			super.updateDisplayList(unscaledWidth, unscaledHeight);

			if (view != null)
			{
				// place the viewport in the middle of the control
				if(this.width / 2 != this.view.x)
					this.view.x = this.width / 2;
				if(this.height / 2 != this.view.y)
					this.view.y = this.height / 2;
			}
		}
		
		public function set nextStateChange(value:String):void
		{
			myNextStateChange = value;
		}
		
		protected function initializeEngine(event:Event):void
		{
			if (!view)
			{
				myNextStateChange = "";
		
				cam = new Camera3D({x:0, y:0, z:-100, lookat:new Number3D(0, 0, 0)});

				view = new View3D({x:stage.width/2, y:stage.height/2, camera:cam});
				view.renderer = Renderer.BASIC;
				view.mouseEnabled = true;
				addChild(view);
								
				addEventListener(Event.ENTER_FRAME, enterFrame);
				addEventListener(MouseEvent.MOUSE_DOWN, this.mouseDown);
				addEventListener(MouseEvent.MOUSE_UP, this.mouseUp);
				addEventListener(MouseEvent.MOUSE_MOVE, this.mouseMove);
				addEventListener(MouseEvent.CLICK, this.click);

				// set the initial frame time
				lastFrame = new Date();

				// initialise the Away3D Flint renderer
				renderer = new Away3DRenderer( view.scene );

				// start the application manager
				applicationManager = new ApplicationManager().startupApplicationManager(this);
			}
		}

		protected function shutdown(event:Event):void
		{
			if (view)
			{
				applicationManager.shutdown();
	
				shutdownAll();
				
				removeChild(view);
				
				removeEventListener(Event.ENTER_FRAME, enterFrame);
				removeEventListener(MouseEvent.MOUSE_DOWN, this.mouseDown);
				removeEventListener(MouseEvent.MOUSE_UP, this.mouseUp);
				removeEventListener(MouseEvent.MOUSE_MOVE, this.mouseMove);
				removeEventListener(MouseEvent.CLICK, this.click);
	
				applicationManager = null;
				view = null;
				cam = null;
				myNextStateChange = "";
				renderer = null;
			}
		}

		protected function enterFrame(event:Event):void
		{
			if (view != null)
			{
				// Calculate the time since the last frame
				var thisFrame:Date = new Date();
				var seconds:Number = (thisFrame.getTime() - lastFrame.getTime())/1000.0;
		    	lastFrame = thisFrame;
	
		    	// sync the baseObjects collection with any BaseObjects created or removed during the
		    	// render loop
		    	removeDeletedBaseObjects();
		    	insertNewBaseObjects();
	
		    	// allow each BaseObject to update itself
		    	for each (var baseObject:BaseObject in baseObjects)
		    		if (baseObject.inuse)
		    			baseObject.enterFrame(seconds);		  
		    			
		    	checkCollisions();  			
		 
		    	// render the 3D scene
		    	view.render();
	  		}
	  		
	  		// set the currentState to MainMenu, which drops us back to the menu
	  		if (myNextStateChange != "")
	  		{	  			
	  			Application.application.currentState = myNextStateChange;
	  			myNextStateChange = "";
	  		}
		}

		public function addBaseObject(baseObject:BaseObject):void
		{
			newBaseObjects.addItem(baseObject);
		}

		public function removeBaseObject(baseObject:BaseObject):void
		{
			removedBaseObjects.addItem(baseObject);
		}

		protected function insertNewBaseObjects():void
		{
			for each (var baseObject:BaseObject in newBaseObjects)
				baseObjects.addItem(baseObject);

			newBaseObjects.removeAll();
		}

		protected function removeDeletedBaseObjects():void
		{
			for each (var removedObject:BaseObject in removedBaseObjects)
			{
				var i:int = 0;
				for (i = 0; i < baseObjects.length; ++i)
				{
					if (baseObjects.getItemAt(i) == removedObject)
					{
						baseObjects.removeItemAt(i);
						break;
					}
				}

			}

			removedBaseObjects.removeAll();
		}
		
		public function shutdownAll():void
		{
			// don't dispose objects twice
			for each (var baseObject:BaseObject in baseObjects)
			{
				var found:Boolean = false;
				for each (var removedObject:BaseObject in removedBaseObjects)
				{
					if (removedObject == baseObject)
					{
						found = true;
						break;
					}
				}

				if (!found)
					baseObject.shutdown();
			}
			
			removeDeletedBaseObjects();
		}
		
		public function click(event:MouseEvent):void
		{
			for each (var gameObject:BaseObject in baseObjects)
				if (gameObject.inuse) 
					gameObject.click(event);
		}
		
		public function mouseDown(event:MouseEvent):void
		{
			for each (var gameObject:BaseObject in baseObjects)
				if (gameObject.inuse) 
					gameObject.mouseDown(event);
		}
		
		public function mouseUp(event:MouseEvent):void
		{
			for each (var gameObject:BaseObject in baseObjects)
				if (gameObject.inuse) 
					gameObject.mouseUp(event);
		}
		
		public function mouseMove(event:MouseEvent):void
		{
			for each (var gameObject:BaseObject in baseObjects)
				if (gameObject.inuse) 
					gameObject.mouseMove(event);
		}
		
		public function addCollidingPair(collider1:String, collider2:String):void
		{
			if (collisionMap[collider1] == null)			
				collisionMap[collider1] = new Array();
				
			if (collisionMap[collider2] == null)
				collisionMap[collider2] = new Array();
								
			if ((collisionMap[collider1] as Array).indexOf(collider2) == -1)
				collisionMap[collider1].push(collider2);
			if ((collisionMap[collider2] as Array).indexOf(collider1) == -1)
				collisionMap[collider2].push(collider1);
		}
		
		protected function checkCollisions():void
		{
	    	for (var i:int = 0; i < baseObjects.length; ++i)
			{
				var gameObjectI:MeshObject = baseObjects.getItemAt(i) as MeshObject;
				
				if (gameObjectI)
				{				
					for (var j:int = i + 1; j < baseObjects.length; ++j)
					{
						var gameObjectJ:MeshObject = baseObjects.getItemAt(j) as MeshObject;
						
						if (gameObjectJ)
						{						
							// early out for non-colliders
							var collisionNameNotNothing:Boolean = gameObjectI.collisionName != CollisionIdentifiers.NONE;
							// objects can still exist in the baseObjects collection after being disposed, so check
							var bothInUse:Boolean = gameObjectI.inuse && gameObjectJ.inuse;
							// make sure we have an entry in the collisionMap
							var collisionMapEntryExists:Boolean = collisionMap[gameObjectI.collisionName] != null;
							// make sure the two objects are set to collide
							var testForCollision:Boolean = collisionMapEntryExists && collisionMap[gameObjectI.collisionName].indexOf(gameObjectJ.collisionName) != -1
							
							if ( collisionNameNotNothing &&					
								 bothInUse &&		
								 collisionMapEntryExists &&
								 testForCollision)
							{
								if (gameObjectI.intersects(gameObjectJ))
								{
									gameObjectI.collision(gameObjectJ);
									gameObjectJ.collision(gameObjectI);
								}
							}
						}					
					}
				}
			}
		}
	}
}

