package
{
	import away3d.core.math.Number3D;
	
	import org.flintparticles.common.actions.*;
	import org.flintparticles.common.counters.*;
	import org.flintparticles.common.energyEasing.Quadratic;
	import org.flintparticles.common.initializers.*;
	import org.flintparticles.common.displayObjects.RadialDot;
	import org.flintparticles.threeD.actions.*;
	import org.flintparticles.threeD.emitters.Emitter3D;
	import org.flintparticles.threeD.geom.Point3D;
	import org.flintparticles.threeD.geom.Vector3D;
	import org.flintparticles.threeD.initializers.*;
	import org.flintparticles.threeD.zones.*;

	public class Explosion extends Emitter3D
	{
		protected static const EXPLOSION_PARTICLE_COUNT:int = 50;
		protected static const EXPLOSION_PARTICLE_SIZE:int = 2;
		protected static const EXPLOSION_PARTICLE_VELOCITY:int = 20;
		protected static const EXPLOSION_PARTICLE_LIFETIME:int = 1;
		
		public function Explosion( position:Number3D )
		{
			counter = new Blast( EXPLOSION_PARTICLE_COUNT );
			
			addInitializer( new A3DDisplayObjectClass( RadialDot, EXPLOSION_PARTICLE_SIZE ) );
			addInitializer( new ColorInit( 0xFFFFFF00, 0xFFFF6600 ) );
			addInitializer( new Position( new PointZone( new Point3D(position.x, position.y, position.z) ) ) );
			addInitializer( new Velocity( new SphereZone( Point3D.ZERO, EXPLOSION_PARTICLE_VELOCITY ) ) );
			addInitializer( new Lifetime( EXPLOSION_PARTICLE_LIFETIME ) );
			
			addAction( new Age( Quadratic.easeIn ) );
			addAction( new Move() );
			addAction( new Fade() );
			addAction( new LinearDrag( 0.5 ) );
		}
	}

}