package
{
	import away3d.core.math.Number3D;
	import away3d.events.MouseEvent3D;
	import away3d.primitives.*;
	
	import flash.events.*;
	import flash.geom.*;
	import flash.media.*;
	
	import mx.core.*;

	public class Player extends DamageableObject
	{
		protected static const PLAYER_X_LIMIT:Number = 52;
		protected static const PLAYER_Y_LIMIT:Number = 38;
		protected static const PLAYER_WIDTH:Number = 16;
		protected static const PLAYER_HEIGHT:Number = 5;
		protected static const COLLISION_PLANE_WIDTH:Number = 150;
		protected static const COLLISION_PLANE_HEIGHT:Number = 100;
		protected static const PLAYER_SHIELDS:int = 10;
		protected var collisionPlane:MeshObject = null;
		protected var shooting:Boolean = false;
		protected var timeToNextShot:Number = 0;
				
		public function Player()
		{			
			super();
		}
		
		public function startupPlayer(engineManager:EngineManager):Player
		{
			var plane:Plane = new Plane(
				{material:ResourceManager.Player_Tex,
				width:PLAYER_WIDTH,
				height:PLAYER_HEIGHT,
				yUp:false});
			super.startupMeshObject(engineManager, plane);
			
			var collisionPlaneMesh:Plane = new Plane(
				{material:new NullMaterial(),
				width:COLLISION_PLANE_WIDTH,
				height:COLLISION_PLANE_HEIGHT,
				yUp:false});
			collisionPlane = new MeshObject().startupMeshObject(engineManager, collisionPlaneMesh);
			collisionPlaneMesh.addEventListener(MouseEvent3D.MOUSE_MOVE, this.mouseMove3D);
			
			this.collisionName = CollisionIdentifiers.PLAYER;
			this.shields = PLAYER_SHIELDS;
			
			Application.application.pbarLife.setProgress(this.shields, PLAYER_SHIELDS);
			
			return this;
		}
		
		override public function shutdown():void
		{
			collisionPlane.model.removeEventListener(MouseEvent3D.MOUSE_MOVE, this.mouseMove3D);
			collisionPlane.shutdown();
			collisionPlane = null;
			super.shutdown();
		}
		
		override public function enterFrame(dt:Number):void
		{
			super.enterFrame(dt);
			
			timeToNextShot -= dt;
			timeToNextShot = timeToNextShot<0?0:timeToNextShot;
			if (timeToNextShot == 0 && shooting)
			{
				var weaponPosition:Number3D = new Number3D();
				weaponPosition.add(this.model.position, new Number3D(PLAYER_WIDTH / 2, 0, 0));
				
				timeToNextShot = this.engineManager.MyApplicationManager.MyWeaponManager.createWeapon(
					this.engineManager.MyApplicationManager.MyPlayerWeapon,
					this.engineManager.MyApplicationManager.MyPlayerWeaponLevel, 
					weaponPosition);
			}
				
			if (this.model.x > PLAYER_X_LIMIT)
				this.model.x = PLAYER_X_LIMIT;
			if (this.model.x < -PLAYER_X_LIMIT)
				this.model.x = -PLAYER_X_LIMIT;
			
			if (this.model.y > PLAYER_Y_LIMIT)
				this.model.y = PLAYER_Y_LIMIT;
			if (this.model.y < -PLAYER_Y_LIMIT)
				this.model.y = -PLAYER_Y_LIMIT;
		}
		
		public function mouseMove3D(event:MouseEvent3D):void
		{
			if (this.model)
			{
				this.model.x = event.sceneX;
				this.model.y = event.sceneY;
			}
		}
		
		public override function collision(other:MeshObject):void
		{
			if (other.collisionName == CollisionIdentifiers.POWERUP)
			{
				var powerup:Powerup = other as Powerup;
				this.shields += powerup.Shields;
				this.engineManager.MyApplicationManager.MyScore += powerup.Score;
				if (powerup.Weapon != 0)
				{
					this.engineManager.MyApplicationManager.changePlayerWeapon(powerup.Weapon);
				}
			}
		}
		
		public override function mouseDown(event:MouseEvent):void
		{
			shooting = true;
		}
		
		public override function damage(amount:int):void
		{
			super.damage(amount);
			Application.application.pbarLife.setProgress(this.shields, PLAYER_SHIELDS);
		}
		
		public override function mouseUp(event:MouseEvent):void
		{
			shooting = false;
		}
		
		protected override function die():void
		{
			engineManager.MyApplicationManager.levelEnded();
			super.die();							
		}
	}
}