package
{
	import away3d.materials.BitmapMaterial;
	import away3d.primitives.Plane;
	
	public class Powerup extends MeshObject
	{
		protected static const POWERUP_SIZE:Number = 6;
		protected static const POWERUP_SPEED:Number = 30;
		protected static const POWERUP_X_LIMIT:Number = 70;
		protected static const POWERUP_Y_LIMIT:Number = 60;
		protected static const POWERUP_X_START:Number = 65;
		protected static const POWERUP_Y_START:Number = 50;
		protected var weapon:int = 0;
		protected var shields:int = 0;
		protected var score:int = 0;
		
		public function get Weapon():int
		{
			return weapon;
		}
		
		public function get Shields():int
		{
			return shields;
		}
		
		public function get Score():int
		{
			return score;
		}
		
		public function Powerup()
		{
			super();
		}
		
		protected function startupPowerup(engineManager:EngineManager, material:BitmapMaterial, weapon:int, score:int, shields:int):Powerup
		{
			var plane:Plane = new Plane(
				{material:material,
				width:POWERUP_SIZE,
				height:POWERUP_SIZE,
				yUp:false});
			super.startupMeshObject(engineManager, plane);
			
			this.collisionName = CollisionIdentifiers.POWERUP;
			this.model.x = POWERUP_X_LIMIT;
			this.model.y = MathUtils.randRange(-POWERUP_Y_START, POWERUP_Y_START);
			this.weapon = weapon;
			this.shields = shields;
			this.score = score;
			
			return this;	
		}
		
		public function startupRandomPowerup(engineManager:EngineManager):Powerup
		{
			var random:int = int(Math.random() * 2);
			switch (random)
			{
				case 0:
					return startupWeapon1Powerup(engineManager);
				case 1:
					return startupWeapon2Powerup(engineManager);
			}
			
			return null;
		}
		
		public function startupWeapon1Powerup(engineManager:EngineManager):Powerup
		{
			return startupPowerup(
				engineManager,
				ResourceManager.Powerup1_Tex,
				1,
				0,
				0);
		}
		
		public function startupWeapon2Powerup(engineManager:EngineManager):Powerup
		{
			return startupPowerup(
				engineManager,
				ResourceManager.Powerup2_Tex,
				2,
				0,
				0);
		}
		
		override public function enterFrame(dt:Number):void
		{
			super.enterFrame(dt);
			
			this.model.x -= POWERUP_SPEED * dt;
			
			if (this.model.x > POWERUP_X_LIMIT ||
				this.model.x < -POWERUP_X_LIMIT ||
				this.model.y > POWERUP_Y_LIMIT ||
				this.model.y < -POWERUP_Y_LIMIT)
				this.shutdown();
		}
		
		override public function collision(other:MeshObject):void
		{
			this.shutdown();
		}
	}
}