package
{
	import away3d.core.math.Number3D;
	import away3d.materials.BitmapMaterial;
	
	import flash.utils.Dictionary;
	
	public class WeaponManager
	{
		protected var engineManager:EngineManager = null;
		protected var weaponDatabase:Dictionary = new Dictionary();
		
		public function WeaponManager()
		{
			super();
		}
		
		public function startupWeaponManager(engineManager:EngineManager):WeaponManager
		{
			this.engineManager = engineManager;
			
			var weapon1:Dictionary = new Dictionary();
			weaponDatabase[1] = weapon1;
			
			weapon1[1] = weapon1Level1;
			weapon1[2] = weapon1Level2;
			
			var weapon2:Dictionary = new Dictionary();
			weaponDatabase[2] = weapon2;
			
			weapon2[1] = weapon2Level1;
			weapon2[2] = weapon2Level2;
			
			return this;
		}
		
		public function createWeapon(weapon:int, weaponLevel:int, position:Number3D):Number
		{
			if (isValidWeapon(weapon, weaponLevel))
			{
				return weaponDatabase[weapon][weaponLevel](position);
			}
			
			return 0;
		}
		
		public function isValidWeapon(weapon:int, weaponLevel:int):Boolean
		{
			if (weaponDatabase[weapon] != null)
			{
				if (weaponDatabase[weapon][weaponLevel] != null)
					return true;
			}
			
			return false;
		}
		
		public function weapon1Level1(weaponPosition:Number3D):Number
		{
			var material:BitmapMaterial = ResourceManager.Bullet_Tex;
			var timeToNextShot:Number = 0.4;
			var damage:int = 1;
			var xDir:Number = 1;
			var yDir:Number = 0;
			var speed:Number = 100;
			new BasicWeapon().startupBasicPlayerWeapon(this.engineManager, material, weaponPosition, damage, xDir, yDir, speed);
			
			new SoundEffect().startupSoundEffect(this.engineManager, ResourceManager.Gun1FX);
			
			return timeToNextShot;
		}
		
		public function weapon1Level2(weaponPosition:Number3D):Number
		{
			var timeToNextShot:Number = 0.4;
			
			var material:BitmapMaterial = ResourceManager.Bullet_Tex;
			var damage:int = 1;
			var xDir:Number = 1;
			var yDir:Number = 0;
			var yDir2:Number = 0.5;
			var yDir3:Number = -0.5;
			var speed:Number = 100;
			new BasicWeapon().startupBasicPlayerWeapon(this.engineManager, material, weaponPosition, damage, xDir, yDir, speed);
			new BasicWeapon().startupBasicPlayerWeapon(this.engineManager, material, weaponPosition, damage, xDir, yDir2, speed);
			new BasicWeapon().startupBasicPlayerWeapon(this.engineManager, material, weaponPosition, damage, xDir, yDir3, speed);
			
			new SoundEffect().startupSoundEffect(this.engineManager, ResourceManager.Gun1FX);
			
			return timeToNextShot;
		}
		
		public function weapon2Level1(weaponPosition:Number3D):Number
		{
			var material:BitmapMaterial = ResourceManager.Bullet2_Tex;
			var timeToNextShot:Number = 1;
			var damage:int = 2;
			var xDir:Number = 1;
			var yDir:Number = 0;
			var speed:Number = 100;
			new BasicWeapon().startupBasicPlayerWeapon(this.engineManager, material, weaponPosition, damage, xDir, yDir, speed);
			
			new SoundEffect().startupSoundEffect(this.engineManager, ResourceManager.Gun1FX);
			
			return timeToNextShot;
		}
		
		public function weapon2Level2(weaponPosition:Number3D):Number
		{
			var material:BitmapMaterial = ResourceManager.Bullet2_Tex;
			var timeToNextShot:Number = 1;
			var damage:int = 1;
			var xDir:Number = 1;
			var yDir:Number = 0;
			var yDir2:Number = 0.5;
			var yDir3:Number = -0.5;
			var speed:Number = 100;
			new BasicWeapon().startupBasicPlayerWeapon(this.engineManager, material, weaponPosition, damage, xDir, yDir, speed);
			new BasicWeapon().startupBasicPlayerWeapon(this.engineManager, material, weaponPosition, damage, xDir, yDir2, speed);
			new BasicWeapon().startupBasicPlayerWeapon(this.engineManager, material, weaponPosition, damage, xDir, yDir3, speed);
			
			new SoundEffect().startupSoundEffect(this.engineManager, ResourceManager.Gun1FX);
			
			return timeToNextShot;
		}

	}
}